/**
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 */

package org.eclipse.higgins.idas.cp.jndi;

import java.net.URI;
import java.util.Iterator;

import javax.naming.NamingException;
import javax.naming.directory.DirContext;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IModel;

public class JNDIContextModel implements IContextModel
{
	private JNDIContext _context;

	public JNDIContextModel(
		JNDIContext context)
	{
		_context = context;
	}

	public IModel getModel(
		URI type)
	{
		IModel model = null;
		DirContext schemaCtx;

		try
		{
			schemaCtx = _context.getDirContext().getSchema(_context.getDirContext().getNameInNamespace());
		}
		catch (NamingException e)
		{
			try
			{
				schemaCtx = _context.getDirContext().getSchema("");
			}
			catch (NamingException e1)
			{
				try
				{
					schemaCtx = _context.getDirContext().getSchema(_context.consumerEntityIDToProvider(_context.getAuthEntityID()));
				}
				catch (NamingException e2)
				{
					return model;
				}
				catch (IdASException e3)
				{
					return model;
				}
			}
			//schemaCtx.close();
		}
		return model;
	}

	public IEntityModel getEntityModel(
		URI entityType)
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Iterator getEntityModels()
	{
		// TODO Auto-generated method stub
		return null;
	}

	public IDisplayData getDisplayData()
	{
		// TODO Auto-generated method stub
		return null;
	}

	public URI getType()
	{
		// TODO Auto-generated method stub
		return null;
	}
}
