/**
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 */

package org.eclipse.higgins.idas.cp.jndi;

import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;
import org.eclipse.higgins.idas.api.IdASException;

/**
*
* @author tdoman@novell.com
*
*/

public class JNDIContextFactoryConfigurableComponentFactory implements IConfigurableComponentFactory
{
	/**
	 * 
	 */
	public IConfigurableComponent getSingletonInstance()
	{
		return null;
	}

	/**
	 * 
	 */
	public IConfigurableComponent getNewInstance()
	{
		IConfigurableComponent iComponentRet;
		try
		{
			iComponentRet = new org.eclipse.higgins.idas.cp.jndi.JNDIContextFactory();
		}
		catch (IdASException e)
		{
			iComponentRet = null;
		}
		return iComponentRet;
	}
}
