/**
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 *		Jim Sermersheim
 */

package org.eclipse.higgins.idas.cp.jndi;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;

/**
*
* @author tdoman@novell.com
* @author jimse@novell.com
*
*/

public class JNDIContextFactory extends BasicAttributeSet implements IContextFactory, IConfigurableComponent
{
//	private Logger _log = Logger.getLogger(JNDIContextFactory.class.getName());
//	private Map _mapGlobalSettings;
//	private Map _mapComponentSettings;

	/**
	 */
	public JNDIContextFactory() throws IdASException
	{
		super();
	}

	/**
	 */
	public String getName() throws IdASException
	{
		return "Higgins JNDI Context Provider";
	}

	/**
	 */
	public Iterator getContexts(
	    String filter) throws IdASException
	{
		throw new NotImplementedException();
	}

	/**
	 */
	public IContext createContext(
		IContextId contextID) throws IdASException
	{
		return new JNDIContext(contextID);
	}

	/**
	 */
	public String getPolicy() throws IdASException
	{
		throw new NotImplementedException();
	}

	/**
	 */
	public void setPolicy(
		String arg0) throws IdASException
	{
		throw new NotImplementedException();
	}

	/**
	 * 
	 * @param mapGlobalSettings
	 * @param strComponentName
	 * @param mapComponentSettings
	 * @throws Exception
	 */
	public void configure(
		final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings) throws Exception
	{
//		_mapGlobalSettings = mapGlobalSettings;
//		_mapComponentSettings = mapComponentSettings;
	}
}
