/**
 * Copyright (c) 2006 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 */
package org.eclipse.higgins.idas.cp.jndi;

import java.security.Provider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eclipse.higgins.idas.cp.jndi.l10n.JNDICPMessages;

/**
* @author tdoman@novell.com
*/

public final class JNDIContextFactoryProvider extends Provider
{
	private Log _log = LogFactory.getLog(JNDIContextFactoryProvider.class.getName());
	private static final long serialVersionUID = 1L;

	public JNDIContextFactoryProvider()
	{
		super("JNDIHigginsProvider", 1.0, "JNDI provider for Higgins ContextFactory objects.");
		_log.debug(JNDICPMessages.CNTX_PROVIDER_INST_MSG);		
		put("ContextFactory.Higgins.JNDI", "org.eclipse.higgins.idas.cp.jndi.JNDIContextFactory");
	}
}
