/**
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 */

package org.eclipse.higgins.idas.cp.jndi;

import javax.naming.NamingException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.SocketFactory;

import org.eclipse.higgins.util.socket.HigginsSSLSocketFactory;

import java.net.Socket;
import java.net.UnknownHostException;
import java.net.InetAddress;
import java.io.File;
import java.io.IOException;

/**
 */
public class LDAPHigginsSSLSocketFactoryProducer extends SSLSocketFactory
{
	private static LDAPHigginsSSLSocketFactoryProducer _myInstance;
	private HigginsSSLSocketFactory _factory;

	/**
	 * 
	 * @param factory
	 */
	private LDAPHigginsSSLSocketFactoryProducer(
		HigginsSSLSocketFactory factory)
	{
		super();
		_factory = factory;
	}

	/**
	 * Produces a single instance of HigginsSSLSocketFactory 
	 */
	public static SocketFactory getDefault()
	{
		if (_myInstance == null)
			_myInstance = new LDAPHigginsSSLSocketFactoryProducer(
				(HigginsSSLSocketFactory)HigginsSSLSocketFactory.getDefault());
		return _myInstance;
	}

	/**
	 * 
	 * @param keyStoreFile
	 */
	public void setKeyStore(
		File keyStoreFile,
		String keyStorePassword)
	{
		_factory.setKeyStore(keyStoreFile, keyStorePassword);
	}

	/**
	 * 
	 * @throws NamingException
	 */
	public void reloadKeyStore() throws NamingException
	{
		_factory.reloadKeyStore();
	}

	/**
	 * 
	 */
	public String[] getDefaultCipherSuites()
	{
		return _factory.getDefaultCipherSuites();
	}

	/**
	 * 
	 */
	public String[] getSupportedCipherSuites()
	{
		return _factory.getSupportedCipherSuites();
	}

	/**
	 * 
	 */
	public Socket createSocket(
		String host,
		int port,
		InetAddress clientHost,
		int clientPort) throws IOException, UnknownHostException
	{
		return _factory.createSocket(host, port, clientHost, clientPort);
	}

	/**
	 * 
	 */
	public Socket createSocket(
		InetAddress inetAddress,
		int i,
		InetAddress inetAddress1,
		int i1) throws IOException
	{
		return _factory.createSocket(inetAddress, i, inetAddress1, i1);
	}

	/**
	 * 
	 */
	public Socket createSocket(
		String host,
		int port) throws IOException, UnknownHostException
	{
		return _factory.createSocket(host, port);
	}

	/**
	 * 
	 */
	public Socket createSocket(
		InetAddress inetAddress,
		int i) throws IOException
	{
		return _factory.createSocket(inetAddress, i);
	}

	/**
	 * 
	 */
	public Socket createSocket(
		Socket socket,
		String host,
		int port,
		boolean autoClose) throws IOException, UnknownHostException
	{
		return _factory.createSocket(socket, host, port, autoClose);
	}
}
