/**
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 *		Jim Sermersheim
 */

package org.eclipse.higgins.idas.cp.jndi;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;

/**
*
* @author tdoman@novell.com
* @author jimse@novell.com
*
*/

public class JNDIContextFactory extends BasicAttributeSet implements IContextFactory, IConfigurableComponent
{
//	private Logger _log = Logger.getLogger(JNDIContextFactory.class.getName());
//	private Map _mapGlobalSettings;
//	private Map _mapComponentSettings;

	private ISettingDescriptor _contextFactoryDescriptor = null;
	private List _contextTypesList = null;
	private String _contextFactoryClassName = null;


	/**
	 */
	public JNDIContextFactory() throws IdASException
	{
		super();
	}

	/**
	 */
	public String getName() throws IdASException
	{
		return "Higgins JNDI Context Provider";
	}

	/**
	 */
	public Iterator getContexts(
	    String filter) throws IdASException
	{
		throw new NotImplementedException();
	}

	/**
	 */
	public IContext createContext(
		IContextId contextID) throws IdASException
	{
		return new JNDIContext(contextID);
	}

	/**
	 */
	public String getPolicy() throws IdASException
	{
		throw new NotImplementedException();
	}

	/**
	 */
	public void setPolicy(
		String arg0) throws IdASException
	{
		throw new NotImplementedException();
	}

	/**
	 * 
	 * @param mapGlobalSettings
	 * @param strComponentName
	 * @param mapComponentSettings
	 * @throws Exception
	 */
	public void configure(
		final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor) throws Exception
	{
//		_mapGlobalSettings = mapGlobalSettings;
//		_mapComponentSettings = mapComponentSettings;
		if ( mapComponentSettings != null ) { 
			this._contextFactoryClassName = (String)mapComponentSettings.get("Instance");
			this._contextTypesList = (List)mapComponentSettings.get("ContextTypes");
		}
		this._contextFactoryDescriptor = componentDescriptor;
	}
	
	public ISettingDescriptor getComponentDescriptor() {
		return this._contextFactoryDescriptor;
	}
	
	public List getTypes() throws IdASException { 
		return this._contextTypesList;
	}
	
	public ISettingDescriptor getContextDescriptor(String contextIdName) throws IdASException { 
		ISettingDescriptor settingDescriptor = new SettingDescriptor(contextIdName, "htf:map");
		settingDescriptor.addSubSetting("ContextId", "xsd:string");
		ISettingDescriptor typesDescriptor = settingDescriptor.addSubSetting("ContextTypes", "htf:list");
		for ( int i = 0; i < this._contextTypesList.size(); i++ ) { 
			typesDescriptor.addSubSetting("JNDIContextType", "xsd:string"); //TODO: Is this right? 
		}
		ISettingDescriptor connectionDescriptor = settingDescriptor.addSubSetting("Connection", "htf:map");
		ISettingDescriptor addrDescriptor = connectionDescriptor.addSubSetting("AddressList", "htf:list");
		addrDescriptor.addSubSetting("Address", "xsd:string");
		connectionDescriptor.addSubSetting("ConnectionType", "xsd:string");
		connectionDescriptor.addSubSetting("jndiProvider", "xsd:string");
		connectionDescriptor.addSubSetting("searchBase", "xsd:string");
		ISettingDescriptor policyDescriptor = settingDescriptor.addSubSetting("JSPolicyAction", "htf:map");
		policyDescriptor.addSubSetting("consumerAIDToProvider", "htf:jscriptexec");
		policyDescriptor.addSubSetting("providerAIDToConsumer", "htf:jscriptexec");
		policyDescriptor.addSubSetting("consumerEntityTypeToProvider", "htf:jscriptexec");
		policyDescriptor.addSubSetting("providerEntityTypeToConsumer", "htf:jscriptexec");
		
		return settingDescriptor;
	}
}
