/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jspolicy;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.jspolicy.JSPolicyContext;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDP;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDPIter;
import org.eclipse.higgins.util.idas.cp.IAttributePDPs;
import org.eclipse.higgins.util.idas.cp.IMetadataPDPs;
import org.eclipse.higgins.util.idas.cp.MetadataPDPIter;
import org.eclipse.higgins.util.idas.cp.jscript.JScriptCPAttributePDPs;
import org.eclipse.higgins.util.idas.cp.jscript.JScriptCPMetadataPDPs;

public class JSPolicyEntity
implements IEntity,
IHasMetadata {
    private JSPolicyContext _policyContext;
    private IEntity _providerEntity;
    private String _uniqueID;
    private URI _type;
    private JScriptCPMetadataPDPs _dsMetadataPDPs;
    private JScriptCPMetadataPDPs _attributeValueMetadataPDP;
    private JScriptCPMetadataPDPs _attributeMetadataPDP;
    private JScriptCPAttributePDPs _attributePDP;

    protected JSPolicyEntity(JScriptCPMetadataPDPs dsMetadataPDPs, JScriptCPAttributePDPs attributePDP, JScriptCPMetadataPDPs attributeValueMetadataPDP, JScriptCPMetadataPDPs attributeMetadataPDP, JSPolicyContext policyContext, IEntity providerEntity, String consumerEntityID, URI consumerURI) throws IdASException {
        this._policyContext = policyContext;
        this._providerEntity = providerEntity;
        this._uniqueID = consumerEntityID;
        this._type = consumerURI;
        this._dsMetadataPDPs = dsMetadataPDPs;
        this._attributeValueMetadataPDP = attributeValueMetadataPDP;
        this._attributeMetadataPDP = attributeMetadataPDP;
        this._attributePDP = attributePDP;
    }

    public IContext getContext() throws IdASException {
        return this._policyContext;
    }

    public String getEntityID() throws IdASException {
        if (this._uniqueID == null) {
            this._uniqueID = this._policyContext.providerEntityIDToConsumer(this._providerEntity.getEntityID());
        }
        return this._uniqueID;
    }

    public URI getEntityType() throws IdASException {
        if (this._type == null) {
            this._type = this._policyContext.providerEntityTypeToConsumer(this._providerEntity.getEntityType());
        }
        return this._type;
    }

    public Iterator getAttributes() throws IdASException {
        return new BasicAttributePDPIter((IAttributePDPs)this._attributePDP, (IMetadataPDPs)this._attributeMetadataPDP, (IMetadataPDPs)this._attributeValueMetadataPDP, this._providerEntity.getAttributes(), true);
    }

    public IAttribute getAttribute(URI attributeID) throws IdASException {
        if (this._attributePDP != null) {
            IAttribute providerAttr = null;
            Iterator itr = this._attributePDP.consumerIDToProviders(attributeID);
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj instanceof URI) {
                    providerAttr = this._providerEntity.getAttribute((URI)obj);
                } else if (obj instanceof String) {
                    try {
                        providerAttr = this._providerEntity.getAttribute(new URI((String)obj));
                    }
                    catch (URISyntaxException e) {
                        throw new IdASException((Throwable)e);
                    }
                } else {
                    throw new IdASException("Illegal object type returned from mapping, consumer URI, got: " + obj.getClass().toString());
                }
                if (providerAttr == null) continue;
                break;
            }
            if (providerAttr != null) {
                return new BasicAttributePDP((IAttributePDPs)this._attributePDP, (IMetadataPDPs)this._attributeMetadataPDP, (IMetadataPDPs)this._attributeValueMetadataPDP, providerAttr, true);
            }
            return null;
        }
        return this._providerEntity.getAttribute(attributeID);
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrType) throws IdASException, NotSingleValuedAttributeException {
        IAttribute attr = this.getAttribute(attrType);
        if (attr.isSingleValued()) {
            return (ISingleValuedAttribute)attr;
        }
        throw new NotSingleValuedAttributeException(attrType + "is not a single-valued attribute");
    }

    public Iterator getMetadataSet() throws IdASException {
        if (this._dsMetadataPDPs != null) {
            return new MetadataPDPIter((IMetadataPDPs)this._dsMetadataPDPs, this._providerEntity.getMetadataSet(), true);
        }
        return this._providerEntity.getMetadataSet();
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        IMetadata metadataItem = null;
        Iterator iter = this.getMetadataSet();
        while (iter.hasNext() && !metadataID.equals((metadataItem = (IMetadata)iter.next()).getModel().getType())) {
        }
        return metadataItem;
    }

    public IMetadata addMetadata(URI type) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        throw new NotImplementedException();
    }

    public IEntityModel getModel() throws IdASException {
        throw new NotImplementedException();
    }

    public void remove() throws IdASException {
        this._providerEntity.remove();
    }

    public IAttribute addAttribute(URI type) throws IdASException, InvalidTypeException {
        return new BasicAttributePDP((IAttributePDPs)this._attributePDP, (IMetadataPDPs)this._attributeMetadataPDP, (IMetadataPDPs)this._attributeValueMetadataPDP, null, false);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        if (copyFrom instanceof BasicAttributePDP) {
            return new BasicAttributePDP((IAttributePDPs)this._attributePDP, (IMetadataPDPs)this._attributeMetadataPDP, (IMetadataPDPs)this._attributeValueMetadataPDP, copyFrom, true);
        }
        return new BasicAttributePDP((IAttributePDPs)this._attributePDP, (IMetadataPDPs)this._attributeMetadataPDP, (IMetadataPDPs)this._attributeValueMetadataPDP, copyFrom, true);
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        return false;
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return false;
    }

    public void removeAttribute(URI attrType) throws IdASException {
    }

    public void removeAttributeValue(URI attrType, Object value) throws IdASException {
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
    }
}

