/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jspolicy;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidEntityIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.cp.jspolicy.JSPolicyEntity;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDPIter;
import org.eclipse.higgins.util.idas.cp.IAttributePDPs;
import org.eclipse.higgins.util.idas.cp.IMetadataPDPs;
import org.eclipse.higgins.util.idas.cp.jscript.JScriptCPAttributePDPs;
import org.eclipse.higgins.util.idas.cp.jscript.JScriptCPMetadataPDPs;
import org.eclipse.higgins.util.jscript.JScriptException;
import org.eclipse.higgins.util.jscript.JScriptExec;
import org.eclipse.higgins.util.jscript.JScriptExecHelper;

public class JSPolicyContext
extends BasicContext {
    public static final String connectionType = "org.eclipse.higgins.idas.cp.jspolicy";
    public static final String consumerEntityIDToProvider = "consumerEntityIDToProvider";
    public static final String providerEntityIDToConsumer = "providerEntityIDToConsumer";
    private JScriptExec _consumerEntityIDToProviderExec;
    private JScriptExec _providerEntityIDToConsumerExec;
    public static final String consumerMIDToProvider = "consumerMIDToProvider";
    public static final String providerMIDToConsumer = "providerMIDToConsumer";
    public static final String consumerAIDToProvider = "consumerAIDToProvider";
    public static final String providerAIDToConsumer = "providerAIDToConsumer";
    public static final String consumerMTypeToProvider = "consumerMTypeToProvider";
    public static final String providerMTypeToConsumer = "providerMTypeToConsumer";
    public static final String consumerATypeToProvider = "consumerATypeToProvider";
    public static final String providerATypeToConsumer = "providerATypeToConsumer";
    public static final String consumerEntityTypeToProvider = "consumerEntityTypeToProvider";
    public static final String providerEntityTypeToConsumer = "providerEntityTypeToConsumer";
    private JScriptExec _consumerEntityTypeToProviderExec;
    private JScriptExec _providerEntityTypeToConsumerExec;
    public static final String consumerAValueToProvider = "consumerAValueToProvider";
    public static final String consumerMValueToProvider = "consumerMValueToProvider";
    public static final String providerAValueToConsumer = "providerAValueToConsumer";
    public static final String providerMValueToConsumer = "providerMValueToConsumer";
    public static final String consumerOpenValueToProvider = "consumerOpenValueToProvider";
    public static final String consumerOpenAIDToProvider = "consumerOpenAIDToProvider";
    public static final String consumerOpenContextRefToProvider = "consumerOpenContextRefToProvider";
    private JScriptExec _consumerOpenContextRefToProviderExec;
    public static final String genericParamName = "PARAM";
    public static final String genericParamName2 = "PARAM2";
    public static final String genericResultName = "RESULT";
    public static final String consumerIDParamName = "consumerID";
    public static final String providerIDParamName = "providerID";
    public static final String consumerTypeParamName = "consumerType";
    public static final String providerTypeParamName = "providerType";
    public static final String consumerContext = "consumerContext";
    public static final String providerContext = "providerContext";
    public static final String attrPDPCache = "attrPDPCache";
    public static final String attrMetadataPDPCache = "attrMetadataPDPCache";
    public static final String getSchema = "getSchema";
    public static final String setSchema = "setSchema";
    public static final String exportData = "exportData ";
    private JScriptExec _getSchemaExec;
    private JScriptExec _setSchemaExec;
    private JScriptExec _exportDataExec;
    private IContextId _contextID;
    private Map _contextSettings;
    private boolean _bIsOpen;
    private boolean _providerContextOwned;
    private IContext _providerContext;
    private JScriptCPMetadataPDPs _dsMetadataPDPs;
    private JScriptCPAttributePDPs _attributePDP;
    private JScriptCPMetadataPDPs _attributeValueMetadataPDP;
    private JScriptCPMetadataPDPs _attributeMetadataPDP;
    private JScriptCPAttributePDPs _openPDPs;

    protected JSPolicyContext(IContextId contextIDs) throws IdASException {
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure((Appender)new NullAppender());
        }
        this._contextID = contextIDs;
        this._contextSettings = this._contextID.getConfiguration();
        this._bIsOpen = false;
        this._providerContext = null;
        this._providerContextOwned = false;
        Map jsPolicySettings = (Map)this._contextSettings.get("JSPolicyAction");
        if (jsPolicySettings != null) {
            this._consumerEntityIDToProviderExec = (JScriptExec)jsPolicySettings.get(consumerEntityIDToProvider);
            this._providerEntityIDToConsumerExec = (JScriptExec)jsPolicySettings.get(providerEntityIDToConsumer);
            this._consumerEntityTypeToProviderExec = (JScriptExec)jsPolicySettings.get(consumerEntityTypeToProvider);
            this._providerEntityTypeToConsumerExec = (JScriptExec)jsPolicySettings.get(providerEntityTypeToConsumer);
            this._consumerOpenContextRefToProviderExec = (JScriptExec)jsPolicySettings.get(consumerOpenContextRefToProvider);
            this._getSchemaExec = (JScriptExec)jsPolicySettings.get(getSchema);
            this._setSchemaExec = (JScriptExec)jsPolicySettings.get(setSchema);
            this._exportDataExec = (JScriptExec)jsPolicySettings.get(exportData);
            this._attributeValueMetadataPDP = this._dsMetadataPDPs = new JScriptCPMetadataPDPs((JScriptExec)jsPolicySettings.get(consumerMIDToProvider), (JScriptExec)jsPolicySettings.get(providerMIDToConsumer), (JScriptExec)jsPolicySettings.get(consumerMTypeToProvider), (JScriptExec)jsPolicySettings.get(providerMTypeToConsumer), (JScriptExec)jsPolicySettings.get(consumerMValueToProvider), (JScriptExec)jsPolicySettings.get(providerMValueToConsumer), false);
            this._attributeMetadataPDP = this._dsMetadataPDPs;
            this._attributePDP = new JScriptCPAttributePDPs((JScriptExec)jsPolicySettings.get(consumerAIDToProvider), (JScriptExec)jsPolicySettings.get(providerAIDToConsumer), (JScriptExec)jsPolicySettings.get(consumerATypeToProvider), (JScriptExec)jsPolicySettings.get(providerATypeToConsumer), (JScriptExec)jsPolicySettings.get(consumerAValueToProvider), (JScriptExec)jsPolicySettings.get(providerAValueToConsumer), false);
            this._openPDPs = new JScriptCPAttributePDPs((JScriptExec)jsPolicySettings.get(consumerOpenAIDToProvider), null, null, null, (JScriptExec)jsPolicySettings.get(consumerOpenValueToProvider), null, true);
        }
    }

    public String open(Object identity) throws IdASException {
        String entityID = null;
        if (this._bIsOpen) {
            throw new ContextOpenException();
        }
        if (identity instanceof IContext) {
            this._providerContext = (IContext)identity;
            this._providerContextOwned = false;
        } else if (identity instanceof IAuthNAttributesMaterials) {
            IdASRegistry reg = IdASRegistry.getInstance();
            try {
                IContextId providerContextID = (IContextId)this._consumerOpenContextRefToProviderExec.evaluate(genericParamName, (Object)this._contextID);
                List factories = reg.getContextFactories(providerContextID);
                Iterator itr = factories.iterator();
                while (itr.hasNext()) {
                    IContextFactory factory = (IContextFactory)itr.next();
                    this._providerContext = factory.createContext(providerContextID);
                    if (this._providerContext != null) break;
                }
                if (this._providerContext == null) {
                    throw new IdASException("Unable to open Context  identity : " + identity.toString() + "  context ID : " + this._contextID.toString());
                }
                Class<?> c = identity.getClass();
                BasicAttributePDPIter props = new BasicAttributePDPIter((IAttributePDPs)this._openPDPs, null, null, ((IAuthNAttributesMaterials)identity).getAttributes(), false);
                Object[] params = new Object[]{props};
                Object newIdentity = null;
                Constructor<?>[] cons = c.getConstructors();
                int iPos = 0;
                while (iPos < cons.length) {
                    Class<?>[] potentialParams = cons[iPos].getParameterTypes();
                    if (potentialParams.length == 1 && potentialParams[0].isAssignableFrom(Class.forName("java.util.Iterator"))) {
                        newIdentity = cons[iPos].newInstance(params);
                        break;
                    }
                    ++iPos;
                }
                entityID = newIdentity != null ? this.providerEntityIDToConsumer(this._providerContext.open(newIdentity)) : this.providerEntityIDToConsumer(this._providerContext.open(identity));
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
            this._providerContextOwned = true;
        }
        this._bIsOpen = true;
        return entityID;
    }

    public void close() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        this._bIsOpen = false;
        if (this._providerContext != null && this._providerContextOwned) {
            this._providerContext.close();
        }
        this._providerContext = null;
        this._providerContextOwned = false;
    }

    public boolean isOpen(Object identity) throws IdASException {
        if (!this._bIsOpen || this._providerContext == null) {
            return false;
        }
        return this._providerContext.isOpen(identity);
    }

    public IEntity getEntity(String entityID, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen || this._providerContext == null) {
            throw new ContextNotOpenException();
        }
        HashSet<URI> providerSelectionList = null;
        if (consumerSelectionList != null) {
            providerSelectionList = new HashSet<URI>();
            while (consumerSelectionList.hasNext()) {
                URI consumerAttrName = (URI)consumerSelectionList.next();
                if (this._attributePDP != null) {
                    Iterator itr = this._attributePDP.consumerIDToProviders(consumerAttrName);
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        if (obj instanceof URI) {
                            providerSelectionList.add((URI)obj);
                            continue;
                        }
                        if (obj instanceof String) {
                            try {
                                providerSelectionList.add(new URI((String)obj));
                                continue;
                            }
                            catch (URISyntaxException e) {
                                throw new IdASException((Throwable)e);
                            }
                        }
                        throw new IdASException("Illegal object type returned from mapping, consumer URI, got: " + obj.getClass().toString());
                    }
                    continue;
                }
                providerSelectionList.add(consumerAttrName);
            }
        }
        return new JSPolicyEntity(this._dsMetadataPDPs, this._attributePDP, this._attributeMetadataPDP, this._attributeMetadataPDP, this, this._providerContext.getEntity(this.consumerEntityIDToProvider(entityID), providerSelectionList != null ? providerSelectionList.iterator() : null), entityID, null);
    }

    public IEntity getEntity(String entityID) throws IdASException {
        return this.getEntity(entityID, null);
    }

    public IEntity addEntity(URI entityType, String entityID) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException {
        if (!this._bIsOpen || this._providerContext == null) {
            throw new ContextNotOpenException();
        }
        IEntity providerDS = this._providerContext.addEntity(this.consumerEntityTypeToProvider(entityType), this.consumerEntityIDToProvider(entityID));
        return new JSPolicyEntity(this._dsMetadataPDPs, this._attributePDP, this._attributeMetadataPDP, this._attributeMetadataPDP, this, providerDS, entityID, entityType);
    }

    public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
        JSPolicyEntity consumerDS = (JSPolicyEntity)this.addEntity(copyFrom.getEntityType(), copyFrom.getEntityID());
        Iterator itr = copyFrom.getAttributes();
        while (itr != null && itr.hasNext()) {
            consumerDS.addAttribute((IAttribute)itr.next());
        }
        itr = copyFrom.getMetadataSet();
        while (itr != null && itr.hasNext()) {
            consumerDS.addMetadata((IMetadata)itr.next());
        }
        return consumerDS;
    }

    public String exportData(String filter, String representationFormat) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        if (this._exportDataExec != null) {
            Object value;
            String[] paramNames = new String[]{genericParamName, genericParamName2, consumerContext, providerContext, attrPDPCache, attrMetadataPDPCache};
            Object[] params = new Object[]{filter, representationFormat, this, this._providerContext, this._attributePDP, this._attributeMetadataPDP};
            try {
                value = this._exportDataExec.evaluate(paramNames, params);
            }
            catch (JScriptException e) {
                throw new IdASException((Throwable)e);
            }
            return (String)value;
        }
        return this._providerContext.exportData(filter, representationFormat);
    }

    public void importData(String filter, String representationFormat) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public String getSchema() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        if (this._getSchemaExec != null) {
            Object value;
            String[] paramNames = new String[]{genericParamName, consumerContext, providerContext, attrPDPCache, attrMetadataPDPCache};
            Object[] params = new Object[]{this._providerContext.getSchema(), this, this._providerContext, this._attributePDP, this._attributeMetadataPDP};
            try {
                value = this._getSchemaExec.evaluate(paramNames, params);
            }
            catch (JScriptException e) {
                throw new IdASException((Throwable)e);
            }
            return (String)value;
        }
        return this._providerContext.getSchema();
    }

    public void setSchema(String schema) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        if (this._setSchemaExec == null) {
            this._providerContext.setSchema(schema);
        }
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        return this.getEntities(filter, null);
    }

    public Iterator getEntities(IFilter filter, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public boolean verifyEntityAttributes(String entityID, Iterator attributes) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        return this._providerContext.verifyEntityAttributes(this.consumerEntityIDToProvider(entityID), (Iterator)new BasicAttributePDPIter((IAttributePDPs)this._attributePDP, (IMetadataPDPs)this._attributeMetadataPDP, (IMetadataPDPs)this._attributeValueMetadataPDP, attributes, false));
    }

    public IContextModel getContextModel() throws IdASException {
        throw new NotImplementedException();
    }

    protected String consumerEntityIDToProvider(String entityID) throws IdASException {
        try {
            return JScriptExecHelper.transformString((JScriptExec)this._consumerEntityIDToProviderExec, (String)consumerIDParamName, (String)entityID);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected String providerEntityIDToConsumer(String entityID) throws IdASException {
        try {
            return JScriptExecHelper.transformString((JScriptExec)this._providerEntityIDToConsumerExec, (String)providerIDParamName, (String)entityID);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected URI consumerEntityTypeToProvider(URI type) throws IdASException {
        try {
            return JScriptExecHelper.transformURI((JScriptExec)this._consumerEntityTypeToProviderExec, (String)consumerTypeParamName, (URI)type);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected URI providerEntityTypeToConsumer(URI type) throws IdASException {
        try {
            return JScriptExecHelper.transformURI((JScriptExec)this._providerEntityTypeToConsumerExec, (String)providerTypeParamName, (URI)type);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }
}

