/**
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  	Duane Buss
 */

package org.eclipse.higgins.idas.cp.jspolicy;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;

/**
 * A <a href="http://www.eclipse.org/higgins/">Higgins</a> Context Provider
 * Factory implementation allowing for javascript policy at critical points.
 * 
 * @author dbuss@novell.com
 */

public class JSPolicyContextFactory  implements IContextFactory, IConfigurableComponent
{
//	private Map _mapGlobalSettings;
//	private Map _mapComponentSettings;

	public JSPolicyContextFactory() throws IdASException
	{
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContextFactory#getName()
	 */
	public String getName() throws IdASException
	{
		return "Higgins JavaScript Policy Context Provider";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContextFactory#getContexts(java.lang.String)
	 */
	public Iterator getContexts(
		String filter) throws IdASException
	{
		throw new NotImplementedException();
	}

	public IContext createContext(IContextId contextID) throws IdASException {
		return new JSPolicyContext(contextID);
		
//		Map contextSettings = this._getContextSettings(contextID);
//		return new JSPolicyContext(contextID, contextSettings);
	}
	/**
	 * 
	 * @param contextRef
	 * @return
	 */
//	private Map _getContextSettings(
//		URI contextRef) throws IdASException
//	{
//		String targetContextID = this._getTargetContext(contextRef);
//		Map contextSettings;
//		if ((_mapGlobalSettings == null)
//			|| ((_mapComponentSettings = (Map)_mapGlobalSettings.get("ComponentSettings")) == null)
//			|| ((contextSettings = (Map)_mapComponentSettings.get(targetContextID)) == null))
//			throw new IdASException("No configuration specified");
//		String contextType;
//		if ((contextType = (String)contextSettings.get("ContextType")) == null)
//			throw new IdASException("No context type specified");
//		if (contextType.compareTo("org.eclipse.higgins.idas.cp.jspolicy") != 0)
//			throw new IdASException("Incorrect context type");
//		return contextSettings;
//	}

	/**
	 * 
	 */
//	private String _getTargetContext(
//		URI contextRef) throws IdASException
//	{
//		String query = contextRef.getQuery();
//		// Hack out just the context "id" piece from any other query
//		// items
//		int iStartOfTargetContext = query.indexOf("id=");
//		if (iStartOfTargetContext == -1)
//			throw new IdASException(
//				"Ill-formed contextRef URI: must contain id specifier");
//		int iEndOfTargetContext = query.indexOf("&", iStartOfTargetContext);
//		if (iEndOfTargetContext == -1)
//			iEndOfTargetContext = query.length();
//		return query.substring(iStartOfTargetContext + 3, iEndOfTargetContext);
//	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContextFactory#getPolicy()
	 */
	public String getPolicy() throws IdASException
	{
		throw new NotImplementedException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContextFactory#setPolicy(java.lang.String)
	 */
	public void setPolicy(
		String policy) throws IdASException
	{
		throw new NotImplementedException();
	}

	/**
	 * 
	 * @param mapGlobalSettings
	 * @param strComponentName
	 * @param mapComponentSettings
	 * @throws Exception
	 */
	public void configure(
		final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings) throws Exception
	{
//		_mapGlobalSettings = mapGlobalSettings;
//		_mapComponentSettings = mapComponentSettings;
	}

}
