/**
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * * Contributors:
 *  	Duane Buss
 *		Tom Doman
 */

package org.eclipse.higgins.idas.cp.jspolicy;

import java.security.Provider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author dbuss@novell.com
 * @author tdoman@novell.com
 */

public final class JSPolicyContextFactoryProvider extends Provider
{
	private Log	 _log = LogFactory.getLog(JSPolicyContextFactoryProvider.class.getName());

	private static final long serialVersionUID = 1L;

	public JSPolicyContextFactoryProvider()
	{
		super("JSPolicyHigginsProvider", 1.0,
			"JavaScript Policy provider for Higgins ContextFactory objects.");
		_log.debug("JavaScript Policy Context Factory Provider instantiated");
		put("ContextFactory.Higgins.JSPolicy",
			"org.eclipse.higgins.idas.cp.jspolicy.JSPolicyContextFactory");
	}
}
