/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf.RDFComplexValue;
import org.eclipse.higgins.idas.cp.rdf.util.BasicValueRelation;
import org.eclipse.higgins.idas.cp.rdf.util.MappingIterator;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicValueString;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;

public class RDFAttribute
extends BasicAttribute {
    private Resource resource;
    private Property property;

    RDFAttribute(Resource resource, Property property) throws IdASException {
        super(URI.create(property.getURI()), null, null, null);
        this.resource = resource;
        this.property = property;
    }

    public Iterator getValues() throws IdASException {
        return new MappingIterator((Iterator)this.resource.listProperties(this.property)){

            public Object map(Object item) {
                Statement statement = (Statement)item;
                RDFNode object = statement.getObject();
                try {
                    if (object.isLiteral()) {
                        object.isAnon();
                        return new BasicValueString(((Literal)object).getString(), (IAttributeValueContainer)RDFAttribute.this);
                    }
                    if (object.isResource() && object.isURIResource()) {
                        return new BasicValueRelation(((Resource)object).getURI(), (IAttributeValueContainer)RDFAttribute.this);
                    }
                    if (object.isResource() && object.isAnon()) {
                        String type = null;
                        if (((Resource)object).hasProperty(RDF.type)) {
                            type = ((Resource)((Resource)object).listProperties(RDF.type).nextStatement().getObject()).getURI();
                        }
                        return new RDFComplexValue((IAttributeValueContainer)RDFAttribute.this, type != null ? URI.create(type) : null, (Resource)object);
                    }
                    return null;
                }
                catch (IdASException idASException) {
                    return null;
                }
            }
        };
    }
}

