/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Markus Sabadello - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.rdf;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;

public class RDFContextFactory implements IContextFactory {

	public RDFContextFactory() throws IdASException {

	}

	public IContext createContext(IContextId contextID) throws IdASException {

		if (contextID == null) throw new IdASException("Parameter \"contextID\" is null.");

		URI uri;
		URL url;

		try {

			List uris = (List) contextID.getConfiguration().get("uris");
			uri = (URI) uris.get(0);

			url = new URL(uri.toString());
		} catch (MalformedURLException ex) {

			throw new IdASException("Malformed URL " + contextID, ex);
		}

		try {

			RDFContext context = new RDFContext(url);
			return context;
		} catch (IdASException ex) {

			throw(ex);
		} catch (Exception ex) {

			throw new IdASException(ex);
		}
	}

	public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {

	}

	public String getName() throws IdASException {

		throw new NotImplementedException();
	}

	public Iterator getContexts(String filter) throws IdASException {

		throw new NotImplementedException();
	}

	public String getPolicy() throws IdASException {

		throw new NotImplementedException();
	}

	public void setPolicy(String policy) throws IdASException {

		throw new NotImplementedException();
	}
}
