/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Markus Sabadello - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.rdf;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf.util.BasicValueRelation;
import org.eclipse.higgins.idas.cp.rdf.util.MappingIterator;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicValueString;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;

public class RDFAttribute extends BasicAttribute {

	private Resource resource;
	private Property property;

	RDFAttribute(Resource resource, Property property) throws IdASException {

		super(URI.create(property.getURI()), (IAttributeValue) null, null, null);

		this.resource = resource;
		this.property = property;
	}

	public Iterator getValues() throws IdASException {

		return(new MappingIterator(this.resource.listProperties(this.property)) {

			public Object map(Object item) {

				Statement statement = (Statement) item;
				RDFNode object = statement.getObject();

				try {

					if (object.isLiteral()) {

						object.isAnon();

						return(new BasicValueString(((Literal) object).getString(), RDFAttribute.this));
					} else if (object.isResource() && object.isURIResource()) {

						return(new BasicValueRelation(((Resource) object).getURI(), RDFAttribute.this));
					} else if (object.isResource() && object.isAnon()) {

						String type = null;
						if (((Resource) object).hasProperty(RDF.type)) type = ((Resource) ((Resource) object).listProperties(RDF.type).nextStatement().getObject()).getURI();

						return(new RDFComplexValue(RDFAttribute.this, type != null ? URI.create(type) : null, (Resource) object));
					} else {

						return(null);
					}
				} catch (IdASException ex) {

					return(null);
				}
			} 
		});
	}
}
