/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Markus Sabadello - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.rdf;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf.util.MappingIterator;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicEntity;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;

public class RDFEntity extends BasicEntity {

	private Resource resource;

	public RDFEntity(BasicContext containerCtx, URI type, Resource resource) throws IdASException {

		super(containerCtx, type, resource.getURI());

		this.resource = resource;
	}

	public IAttribute getAttribute(URI attrID) throws IdASException {

		if (attrID == null) throw new IdASException("Parameter \"attrID\" is null.");

		Property property = new PropertyImpl(attrID.toString());

		if (! this.resource.hasProperty(property)) return(null);

		return(new RDFAttribute(this.resource, property));
	}

	public Iterator getAttributes() throws IdASException {

		Map map = new HashMap();

		for (StmtIterator iterator = this.resource.listProperties(); iterator.hasNext(); ) {

			Statement statement = iterator.nextStatement();
			Property property = statement.getPredicate();

			map.put(property.getURI(), property);
		}

		return(new MappingIterator(map.entrySet().iterator()) {

			public Object map(Object item) {

				Map.Entry entry = (Map.Entry) item;
				Property property = (Property) entry.getValue();

				try {

					return(new RDFAttribute(RDFEntity.this.resource, property));
				} catch (IdASException ex) {

					return(null);
				}
			} 
		});
	}
}
