/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedEntity;
import org.eclipse.higgins.idas.cp.xmlfile.SharedEntity;

public class EntityIterator
implements Iterator {
    private NonsharedContext _nonsharedContext;
    private IFilter _basicFilter;
    private SharedEntity _currEntity;
    private int _iCurrEntityNum;

    EntityIterator(NonsharedContext context, IFilter basicFilter) {
        this._nonsharedContext = context;
        this._basicFilter = basicFilter;
        this._currEntity = null;
        this._iCurrEntityNum = -1;
    }

    private boolean _syncEntity(boolean bMustFindExact) throws IdASException {
        String szEntityID;
        ArrayList entityList = this._nonsharedContext.getSharedContext().getEntityList();
        Map entityMap = this._nonsharedContext.getSharedContext().getEntityMap();
        SharedEntity sharedEntity = (SharedEntity)entityMap.get(szEntityID = this._currEntity.getEntityID());
        if (sharedEntity != null) {
            this._currEntity = sharedEntity;
            if (this._iCurrEntityNum >= entityList.size() || this._currEntity != (SharedEntity)entityList.get(this._iCurrEntityNum)) {
                this._iCurrEntityNum = 0;
                while (this._iCurrEntityNum < entityList.size() && this._currEntity != (SharedEntity)entityList.get(this._iCurrEntityNum)) {
                    ++this._iCurrEntityNum;
                }
            }
        } else {
            if (bMustFindExact) {
                return false;
            }
            --this._iCurrEntityNum;
            if (this._iCurrEntityNum >= 0 && this._iCurrEntityNum < entityList.size()) {
                this._currEntity = (SharedEntity)entityList.get(this._iCurrEntityNum);
            } else {
                return false;
            }
        }
        return true;
    }

    private int _getNextEntityNum() {
        try {
            int iNextEntityNum;
            if (this._nonsharedContext.sync(false) && this._currEntity != null && !this._syncEntity(false)) {
                return -1;
            }
            if (this._currEntity == null) {
                iNextEntityNum = 0;
            } else {
                if (this._currEntity.isDeleted() && !this._syncEntity(false)) {
                    return -1;
                }
                iNextEntityNum = this._iCurrEntityNum + 1;
            }
            ArrayList entityList = this._nonsharedContext.getSharedContext().getEntityList();
            while (iNextEntityNum < entityList.size()) {
                if (this._nonsharedContext.getSharedContext().testEntity((SharedEntity)entityList.get(iNextEntityNum), this._basicFilter)) {
                    return iNextEntityNum;
                }
                ++iNextEntityNum;
            }
        }
        catch (IdASException idASException) {
            // empty catch block
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        int iNextEntityNum = -1;
        if (!this._nonsharedContext.isOpen()) {
            return false;
        }
        try {
            this._nonsharedContext.lockSharedContext();
            iNextEntityNum = this._getNextEntityNum();
        }
        catch (IdASException e) {
            iNextEntityNum = -1;
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return iNextEntityNum != -1;
    }

    public Object next() {
        if (!this._nonsharedContext.isOpen()) {
            throw new NoSuchElementException();
        }
        try {
            this._nonsharedContext.lockSharedContext();
            int iNextEntityNum = this._getNextEntityNum();
            if (iNextEntityNum == -1) {
                this._currEntity = null;
                throw new NoSuchElementException();
            }
            ArrayList entityList = this._nonsharedContext.getSharedContext().getEntityList();
            this._currEntity = (SharedEntity)entityList.get(iNextEntityNum);
            this._iCurrEntityNum = iNextEntityNum;
        }
        catch (IdASException e) {
            throw new NoSuchElementException("IdAS exception occurred: " + e.getMessage());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return new NonsharedEntity(this._nonsharedContext, this._currEntity);
    }

    public void remove() {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new IllegalStateException("IdAS context is no longer open");
        }
        if (this._currEntity == null || this._currEntity.isDeleted()) {
            throw new IllegalStateException();
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            if (this._nonsharedContext.sync(bStartedTrans) && !this._syncEntity(true)) {
                throw new NoSuchElementException();
            }
            this._currEntity.remove();
        }
        catch (IdASException e) {
            throw new IllegalStateException("IdAS exception occurred: " + e.getMessage());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }
}

