/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.apache.log4j.Logger;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.api.model.IMetadataModel;

/**
 */
public class NonsharedAttributeModel implements IAttributeModel
{
	private Logger					_log = Logger.getLogger( NonsharedAttributeModel.class.getName());
	private NonsharedAttribute	_nonsharedAttr;
	
	NonsharedAttributeModel(
		NonsharedAttribute	nonsharedAttr)
	{
		_nonsharedAttr =  nonsharedAttr;
	}
	
	/**
	 */
	public IAttributeValueModel getValueModel()
	{
		return( new NonsharedAttributeValueModel( _nonsharedAttr));
	}
	
	public boolean isDirect()
	{
		return( false);
	}

	/**
	 */
	public java.util.Iterator getMetadataModels()
	{
		return( null);
	}
	
	/**
	 */
	public IMetadataModel getMetadataModel(
		java.net.URI	metadataID)	
	{
		return( null);
	}
	
	/**
	 */
	public java.net.URI getType()
	{
//VISIT: Change to NOT catch the IdASException of getType() interface is changed in new IDAS to throw an exception.
		try
		{
			return( _nonsharedAttr.getAttrID());
		}
		catch (IdASException e)
		{
		}
		return( null);
	}

	/**
	 */
	public IDisplayData getDisplayData()
	{
		return( null);
	}

	public int getMaxCardinality()
	{
		return -1;
	}

	public int getMinCardinality()
	{
		return -1;
	}
}

