/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.apache.log4j.Logger;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;

/**
 */
public class NonsharedComplexAttrValue implements IComplexAttrValue, NonsharedAttrContainer
{
	private Logger							_log = Logger.getLogger( NonsharedComplexAttrValue.class.getName());
	private NonsharedContext			_nonsharedContext;
	private NonsharedAttribute			_nonsharedAttr;
	private long							_lAttrSyncCount;
	private NonsharedAttrContainer	_nonsharedAttrContainer;
	private SharedComplexAttrValue	_sharedComplexAttrValue;
	private long							_lSyncCount = 0;

	NonsharedComplexAttrValue(
		NonsharedAttribute		nonsharedAttr,
		SharedComplexAttrValue	complexValue)
	{
		_nonsharedAttr = nonsharedAttr;
		_lAttrSyncCount = _nonsharedAttr.getSyncCount();
		_nonsharedAttrContainer = nonsharedAttr.getNonSharedAttrContainer();
		_nonsharedContext = _nonsharedAttrContainer.getNonSharedContext();
		_sharedComplexAttrValue = complexValue;
	}
	
	// nonsharedAttrContainer methods
	
	public NonsharedContext getNonSharedContext()
	{
		return( _nonsharedContext);
	}
	
	public SharedAttrContainer getSharedContainer()
	{
		return( _sharedComplexAttrValue);
	}
	
	public java.util.ArrayList getAttrList()
	{
		return( _sharedComplexAttrValue.getAttrList());
	}
	
	public java.util.Map getAttrMap()
	{
		return( _sharedComplexAttrValue.getAttrMap());
	}
	
	public String getContainerType()
	{
		return( "complex attribute");
	}
	
	public String getContainerID()
	{
		return( _nonsharedAttr.getSharedAttribute().getAttrID());
	}
	
	public long getSyncCount()
	{
		return( _lSyncCount);
	}
	
	public boolean sync(
		boolean	bForceSync) throws IdASException
	{
		String	szErrMsg;
		boolean	bSynced = false;
		int		iFoundNum;
		
		if (_nonsharedAttr.sync( bForceSync) || _lAttrSyncCount != _nonsharedAttr.getSyncCount())
		{
			bForceSync = true;
		}
		
		// See if we have the value

		if (bForceSync || _sharedComplexAttrValue == null || _sharedComplexAttrValue.isDeleted())
		{
			if ((iFoundNum = _nonsharedAttr.getSharedAttribute().findAttrValue( _sharedComplexAttrValue)) == -1)
			{
				_sharedComplexAttrValue = null;
			}
			else
			{
				_sharedComplexAttrValue = (SharedComplexAttrValue)_nonsharedAttr.getSharedAttribute().getValueList().get( iFoundNum);
			}
			bSynced = true;
			_lSyncCount++;
			_lAttrSyncCount = _nonsharedAttr.getSyncCount();
		}
		if (_sharedComplexAttrValue == null)
		{
			szErrMsg = "Value in attribute '" + _nonsharedAttr.getSharedAttribute().getAttrID() + "' on " +
				_nonsharedAttrContainer.getContainerType() + " '" + _nonsharedAttrContainer.getContainerID() + " no longer exists";
			
			_log.debug( szErrMsg);
			throw new IdASException( szErrMsg);
		}
		return( bSynced);
	}
	
	// IAttributeValue methods

	/**
	 */
	public boolean isSimple() throws IdASException
	{
		return( false);
	}
	
	/**
	 */
	public java.net.URI getDataType() throws IdASException
	{
		java.net.URI	dataType = null;
		String			szAttrDataType;
		String			szErrMsg;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:getType(): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			if ((szAttrDataType = _sharedComplexAttrValue.getDataType()) == null)
			{
				szErrMsg = "Data type for value on attribute '" + _nonsharedAttr.getSharedAttribute().getAttrID() + "' on " +
								_nonsharedAttrContainer.getContainerType() + " '" + _nonsharedAttrContainer.getContainerID() + "' not defined";
				_log.debug( szErrMsg);
				throw new IdASException( szErrMsg);
			}
			dataType = java.net.URI.create( szAttrDataType);
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		
		return( dataType);
	}

	/**
	 */
	public void remove() throws IdASException
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:remove(): Context not open");
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			sync( bStartedTrans);
			_sharedComplexAttrValue.remove();
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}
	
	/**
	 */
	public boolean equals(
		IAttributeValue	value) throws IdASException
	{
		boolean	bEqual = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:equals(IAttributeValue): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			bEqual = _sharedComplexAttrValue.equals( value);
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		
		return( bEqual);
	}
	
	/**
	 */
	public boolean equals(
		IHasAttributes	attributes) throws IdASException
	{
		boolean	bEqual = true;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:equals(IHasAttributes): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			bEqual = _sharedComplexAttrValue.equals( attributes);
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		
		return( bEqual);
	}
	
	// IHasMetadata methods
	
	/**
	 */
	public java.util.Iterator getMetadataSet() throws IdASException
	{
		throw new NotImplementedException( "Not Implemented: nonsharedComplexAttrValue:getMetadataSet()");
	}

	/**
	 */
	public IMetadata getMetadata(
		java.net.URI	metadataID) throws IdASException
	{
		throw new NotImplementedException( "Not Implemented: nonsharedComplexAttrValue:getMetadata(metadataID)");
	}
	
	/**
	 */
	public IMetadata addMetadata(
		java.net.URI	metadataID) throws IdASException, InvalidTypeException
	{
		throw new NotImplementedException( "Not Implemented: nonsharedComplexAttrValue:addMetadata(metadataID)");
	}
	
	/**
	 */
	public IMetadata addMetadata(
		IMetadata	copyFrom) throws IdASException
	{
		throw new NotImplementedException( "Not Implemented: nonsharedComplexAttrValue:addMetadata(copyFrom)");
	}
	
	/**
	 */
	public boolean equals(
		IHasMetadata	metadataSet) throws IdASException
	{
		throw new NotImplementedException( "Not Implemented: nonsharedComplexAttrValue:equals(metadataSet)");
	}
	
	// IHasAttributes methods
	
	/**
	 */
	public java.util.Iterator getAttributes() throws IdASException
	{
		java.util.Iterator	iter = null;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:getAttributes(): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			iter = new AttrIterator( this);
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		
		return( iter);
	}
	
	/**
	 */
	public IAttribute getAttribute(
		java.net.URI	attrID) throws IdASException
	{
		SharedAttribute	sharedAttr = null;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:getAttribute(attrID): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			sharedAttr = _sharedComplexAttrValue.getAttribute( attrID.toString());
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		return( sharedAttr == null ? null : new NonsharedAttribute( this, sharedAttr));
	}

	/**
	 */
	public ISingleValuedAttribute getSingleValuedAttribute(
		java.net.URI	attrID) throws IdASException, NotSingleValuedAttributeException
	{
		SharedAttribute	sharedAttr = null;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:getSingleValuedAttribute(attrID): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			sharedAttr = _sharedComplexAttrValue.getSingleValuedAttribute( attrID.toString());
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		return( sharedAttr == null ? null : new NonsharedAttribute( this, sharedAttr));
	}

	/**
	 */
	public IAttribute addAttribute(
		java.net.URI	attrID) throws IdASException, InvalidTypeException
	{
		boolean				bStartedTrans = false;
		SharedAttribute	sharedAttr = null;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:addAttribute(attrID): Context not open");
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			sync( bStartedTrans);
			sharedAttr = _sharedComplexAttrValue.addAttribute( attrID.toString());
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
		return( sharedAttr == null ? null : new NonsharedAttribute( this, sharedAttr));
	}
	
	/**
	 */
	public IAttribute addAttribute(
		IAttribute copyFrom) throws IdASException
	{
		boolean				bStartedTrans = false;
		SharedAttribute	sharedAttr = null;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:addAttribute(copyFrom): Context not open");
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			sharedAttr = _sharedComplexAttrValue.addAttribute( copyFrom);
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
		return( sharedAttr == null ? null : new NonsharedAttribute( this, sharedAttr));
	}

	/**
	 */
	public void removeAttribute(
		java.net.URI	attrID) throws IdASException
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:removeAttribute(attrID): Context not open");
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			sync( bStartedTrans);
			_sharedComplexAttrValue.removeAttribute( attrID.toString());
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}

	/**
	 */
	public void removeAttributeValue(
		java.net.URI	attrID,
		Object			value) throws IdASException
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:removeAttributeValue(attrID,value): Context not open");
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			sync( bStartedTrans);
			_sharedComplexAttrValue.removeAttributeValue( attrID.toString(), value);
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}

	/**
	 */
	public void removeAttributeValue(
		IAttribute	attr) throws IdASException
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedComplexAttrValue:removeAttributeValue(IAttribute): Context not open");
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			sync( bStartedTrans);
			_sharedComplexAttrValue.removeAttributeValue( attr);
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}

	public IAttributeValueModel getModel() throws IdASException {
		throw new NotImplementedException();
	}
}

