/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.apache.log4j.Logger;

import org.eclipse.higgins.idas.api.IdASException;

import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IHasAttributes;

/**
 */
public class SharedComplexAttrValue extends SharedAttrContainer implements SharedAttributeValue
{
	private Logger				_log = Logger.getLogger( SharedComplexAttrValue.class.getName());
	private SharedAttribute	_sharedAttr;
	private boolean			_bDeleted;

	SharedComplexAttrValue(
		SharedAttribute	sharedAttr)
	{
		super();
		_bDeleted = false;
		_sharedAttr = sharedAttr;
	}
	
	// sharedAttributeValue methods
	
	public void setDeleted()
	{
		_bDeleted = true;
	}
	
	public boolean isDeleted()
	{
		return( _bDeleted);
	}
	
	public boolean isSimple()
	{
		return( false);
	}
	
	public String getDataType()
	{
		return( _sharedAttr.getAttrDataType());
	}

	public void remove() throws IdASException
	{
		java.util.ArrayList	valueList = _sharedAttr.getValueList();
		
		for (int iLoop = 0; iLoop < valueList.size(); iLoop++)
		{
			if (this == (SharedComplexAttrValue)valueList.get( iLoop))
			{
				valueList.remove( iLoop);
				break;
			}
		}
		_bDeleted = true;
	}
	
	public boolean equals(
		IAttributeValue	value) throws IdASException
	{
		String	szValueType = value.getDataType().toString();
		
		// Make sure the value's type matches the attribute type

		if (_sharedAttr.getAttrDataType() == null ||		
			 !_sharedAttr.getAttrDataType().equals( szValueType))
		{
			return( false);
		}
		
		// Must be a complex type
		
		if (value.isSimple())
		{
			return( false);
		}
		
		// Match each of the attributes on the value
		
		return( equals( (IHasAttributes)((IComplexAttrValue)value)));
	}
		
	// Abstract methods of the sharedAttrContainer class
	
	String getContainerType()
	{
		return( "complex attribute");
	}
	
	String getContainerID()
	{
		return( _sharedAttr.getAttrID());
	}
	
	Logger getLogger()
	{
		return( _log);
	}
}

