/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.apache.log4j.Logger;

import org.eclipse.higgins.idas.api.IdASException;

/**
 * 
 * @author dsanders@novell.com
 * 
 */

public class SharedEntity extends SharedAttrContainer
{
	private Logger				_log = Logger.getLogger( SharedEntity.class.getName());
	private SharedContext	_sharedContext;
	private String				_szEntityType;
	private String				_szEntityID;
	private boolean			_bDeleted;

	SharedEntity(
		SharedContext			sharedCtx,
		String					szEntityType,
		String					szEntityID) throws IdASException
	{
		super();
		_bDeleted = false;
		_sharedContext = sharedCtx;
		_szEntityType = szEntityType;
		_szEntityID = szEntityID;
	}
	
	void setDeleted()
	{
		_bDeleted = true;
	}
	
	boolean isDeleted()
	{
		return( _bDeleted);
	}
	
	String getEntityType()
	{
		return( _szEntityType);
	}
	
	void setEntityID(
		String	szEntityID)
	{
		_szEntityID = szEntityID;
	}

	String getEntityID()
	{
		return( _szEntityID);
	}

	String getContainerID()
	{
		return( _szEntityID);
	}
	
	String getContainerType()
	{
		return( "entity");
	}
	
	Logger getLogger()
	{
		return( _log);
	}

	void remove() throws IdASException
	{
		_sharedContext.removeEntity( _szEntityID);
	}
}

