/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedContext;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;

public class NonsharedContextFactory
extends BasicAttributeSet
implements IContextFactory,
IConfigurableComponent {
    public static final String XML_FILENAME_SETTING = "XmlFileName";
    private Log _log = LogFactory.getLog((String)(class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContextFactory == null ? (class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContextFactory = NonsharedContextFactory.class$("org.eclipse.higgins.idas.cp.xmlfile.NonsharedContextFactory")) : class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContextFactory).getName());
    private static HashMap _SimpleDataTypes = null;
    static HashMap SharedContextTable = new HashMap();
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContextFactory;

    public NonsharedContextFactory() throws IdASException {
        NonsharedContextFactory._initSimpleDataTypes();
    }

    public static boolean isSimpleDataType(String szDataType) {
        return _SimpleDataTypes.get(szDataType) != null;
    }

    private static synchronized void _initSimpleDataTypes() {
        if (_SimpleDataTypes == null) {
            _SimpleDataTypes = new HashMap();
            for (int iLoop = 0; iLoop < ITypedValue.typeMap.length; ++iLoop) {
                String[] TypeClass = ITypedValue.typeMap[iLoop];
                _SimpleDataTypes.put(TypeClass[0], TypeClass[1]);
            }
        }
    }

    public String getName() throws IdASException {
        return "Higgins XML File Context Provider";
    }

    public Iterator getContexts(String filter) throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedContextFactory:getContexts(filter)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContext createContext(IContextId contextID) throws IdASException {
        SharedContext sharedCtx;
        int iLoop;
        Map contextSettings = contextID.getConfiguration();
        String szXmlFileName = (String)contextSettings.get(XML_FILENAME_SETTING);
        URI[] contextURIs = contextID.getUris();
        String szContextURIs = "";
        String[] contextTypes = contextID.getTypes();
        String szContextTypes = "";
        for (iLoop = 0; iLoop < contextURIs.length; ++iLoop) {
            if (iLoop > 0) {
                szContextURIs = szContextURIs + ", ";
            }
            szContextURIs = szContextURIs + contextURIs[iLoop].toString();
        }
        for (iLoop = 0; iLoop < contextTypes.length; ++iLoop) {
            if (iLoop > 0) {
                szContextTypes = szContextTypes + ", ";
            }
            szContextTypes = szContextTypes + contextTypes[iLoop];
        }
        try {
            File tmpFile = new File(szXmlFileName);
            szXmlFileName = tmpFile.getCanonicalPath();
        }
        catch (Exception e) {
            String szErrMsg = "Error getting canonical path for file name '" + szXmlFileName + "': " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        HashMap hashMap = SharedContextTable;
        synchronized (hashMap) {
            sharedCtx = (SharedContext)SharedContextTable.get(szXmlFileName);
            if (sharedCtx == null) {
                sharedCtx = new SharedContext(szXmlFileName);
                sharedCtx.setOpenCount(1);
                sharedCtx.setLastCloseTime(0L);
                SharedContextTable.put(szXmlFileName, sharedCtx);
            } else {
                sharedCtx.incrOpenCount();
            }
            Iterator contextIter = SharedContextTable.keySet().iterator();
            while (contextIter.hasNext()) {
                String szFileName = (String)contextIter.next();
                SharedContext tmpSharedCtx = (SharedContext)SharedContextTable.get(szFileName);
                if (tmpSharedCtx.getOpenCount() != 0 || tmpSharedCtx.getLastCloseTime() + 3600000L >= System.currentTimeMillis()) continue;
                tmpSharedCtx.close();
                SharedContextTable.remove(szFileName);
            }
        }
        return new NonsharedContext(sharedCtx, szContextURIs, szContextTypes);
    }

    public String getPolicy() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedContextFactory:getPolicy()");
    }

    public void setPolicy(String arg0) throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedContextFactory:setPolicy(arg0)");
    }

    public void configure(Map mapGlobalSettings, String szComponentName, Map mapComponentSettings) throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

