/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedSimpleAttrValue;

public class NonsharedSimpleAttrValue
implements ISimpleAttrValue {
    private Log _log = LogFactory.getLog((String)(class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedSimpleAttrValue == null ? (class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedSimpleAttrValue = NonsharedSimpleAttrValue.class$("org.eclipse.higgins.idas.cp.xmlfile.NonsharedSimpleAttrValue")) : class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedSimpleAttrValue).getName());
    private NonsharedContext _nonsharedContext;
    private NonsharedAttribute _nonsharedAttr;
    private long _lAttrSyncCount;
    private NonsharedAttrContainer _nonsharedAttrContainer;
    private SharedSimpleAttrValue _sharedSimpleAttrValue;
    private long _lSyncCount = 0L;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedSimpleAttrValue;

    NonsharedSimpleAttrValue(NonsharedAttribute nonsharedAttr, SharedSimpleAttrValue simpleValue) {
        this._nonsharedAttr = nonsharedAttr;
        this._lAttrSyncCount = this._nonsharedAttr.getSyncCount();
        this._nonsharedAttrContainer = nonsharedAttr.getNonSharedAttrContainer();
        this._nonsharedContext = this._nonsharedAttrContainer.getNonSharedContext();
        this._sharedSimpleAttrValue = simpleValue;
    }

    long getSyncCount() {
        return this._lSyncCount;
    }

    boolean sync(boolean bForceSync) throws IdASException {
        boolean bSynced = false;
        if (this._nonsharedAttr.sync(bForceSync) || this._lAttrSyncCount != this._nonsharedAttr.getSyncCount()) {
            bForceSync = true;
        }
        if (bForceSync || this._sharedSimpleAttrValue == null || this._sharedSimpleAttrValue.isDeleted()) {
            int iFoundNum = this._nonsharedAttr.getSharedAttribute().findAttrValue(this._sharedSimpleAttrValue);
            this._sharedSimpleAttrValue = iFoundNum == -1 ? null : (SharedSimpleAttrValue)this._nonsharedAttr.getSharedAttribute().getValueList().get(iFoundNum);
            bSynced = true;
            ++this._lSyncCount;
            this._lAttrSyncCount = this._nonsharedAttr.getSyncCount();
        }
        if (this._sharedSimpleAttrValue == null) {
            String szErrMsg = "Value in attribute '" + this._nonsharedAttr.getSharedAttribute().getAttrID() + "' on " + this._nonsharedAttrContainer.getContainerType() + " '" + this._nonsharedAttrContainer.getContainerID() + " no longer exists";
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        return bSynced;
    }

    public boolean isSimple() throws IdASException {
        return true;
    }

    public URI getDataType() throws IdASException {
        return this.getValueType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getValueType() throws IdASException {
        URI dataType = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedSimpleAttrValue:getType(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            String szAttrDataType = this._sharedSimpleAttrValue.getDataType();
            if (szAttrDataType == null) {
                String szErrMsg = "Data type for value on attribute '" + this._nonsharedAttr.getSharedAttribute().getAttrID() + "' on " + this._nonsharedAttrContainer.getContainerType() + " '" + this._nonsharedAttrContainer.getContainerID() + "' not defined";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            dataType = URI.create(szAttrDataType);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return dataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedSimpleAttrValue:remove(): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedSimpleAttrValue.remove();
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(IAttributeValue value) throws IdASException {
        boolean bEqual = true;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedSimpleAttrValue:equals(IAttributeValue): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            bEqual = this._sharedSimpleAttrValue.equals(value);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return bEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLexical() throws IdASException {
        String szValue = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedSimpleAttrValue:getLexical(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            szValue = this._sharedSimpleAttrValue.getLexical();
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return szValue;
    }

    public String getCanonical() throws IdASException {
        return this.getLexical();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData() throws IdASException {
        Object obj = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedSimpleAttrValue:getData(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            obj = this._sharedSimpleAttrValue.getData();
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Object data) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedSimpleAttrValue:setData(data): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedSimpleAttrValue.setData(data);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    public IAttributeSimpleValueModel getModel() throws IdASException {
        throw new NotImplementedException();
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        throw new NotImplementedException();
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        throw new NotImplementedException();
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public Iterator getAttributes() throws IdASException {
        throw new NotImplementedException();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        throw new NotImplementedException();
    }

    public void removeAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        throw new NotImplementedException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

