/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import openxdas.XDasException;
import openxdas.XDasRecord;
import openxdas.XDasSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.common.AuthNAnonymousMaterials;
import org.eclipse.higgins.idas.cp.xmlfile.EntityIterator;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContextFactory;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedEntity;
import org.eclipse.higgins.idas.cp.xmlfile.SharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedEntity;
import org.eclipse.higgins.idas.spi.BasicContext;

public class NonsharedContext
extends BasicContext {
    private Log _log;
    private SharedContext _readOnlyContext;
    private SharedContext _updateContext;
    private String _szEntityID;
    private XDasSession _xdasSession;
    private Object _identity;
    private int _iLockCount;
    private boolean _bIsOpen;
    private long _lLastModifiedTime;
    private String _szContextURIs;
    private String _szContextTypes;
    private long _lSyncCount;
    static /* synthetic */ Class class$0;

    public NonsharedContext(SharedContext readOnlyContext, String szContextURIs, String szContextTypes) throws IdASException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((String)clazz.getName());
        this._identity = null;
        this._iLockCount = 0;
        this._bIsOpen = false;
        this._lSyncCount = 0L;
        this._szContextURIs = szContextURIs;
        this._szContextTypes = szContextTypes;
        this._readOnlyContext = readOnlyContext;
        this._lLastModifiedTime = this._readOnlyContext.getLastModifiedTime();
        this._updateContext = null;
        this._bIsOpen = false;
        this._iLockCount = 0;
        this._identity = null;
        this._szEntityID = null;
        this._xdasSession = null;
        this._initXDASSession();
    }

    long getSyncCount() {
        return this._lSyncCount;
    }

    boolean sync(boolean bForceSync) throws IdASException {
        boolean bSynced = false;
        if (this._updateContext != null) {
            bSynced = bForceSync;
        } else if (bForceSync || this._lLastModifiedTime != this._readOnlyContext.getLastModifiedTime()) {
            this._lLastModifiedTime = this._readOnlyContext.getLastModifiedTime();
            bSynced = true;
        }
        if (bSynced) {
            ++this._lSyncCount;
        }
        return bSynced;
    }

    private void _initXDASSession() throws IdASException {
        try {
            this._xdasSession = new XDasSession("Higgins IdAS XML File Context Provider", null, null, null, null, null);
        }
        catch (XDasException e) {
            throw new IdASException((Throwable)e);
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {}
    }

    private void _emitXDASRecord(int iEventNumber, int iOutcome, String sInitiatorInfo, String sTargetInfo, String sEventInfo) throws IdASException {
        if (this._xdasSession != null) {
            if (sTargetInfo == null) {
                sTargetInfo = "";
            }
            if (sEventInfo == null) {
                sEventInfo = "";
            }
            try {
                XDasRecord xdasRecord = this._xdasSession.XDasStartRecord(iEventNumber, iOutcome, null, null, sEventInfo);
                xdasRecord.setInitiatorInfo(null, null, sInitiatorInfo);
                xdasRecord.setTargetInfo(null, this._szContextURIs, this._szContextTypes, null, null, sTargetInfo);
                xdasRecord.commit();
            }
            catch (XDasException e) {
                throw new IdASException((Throwable)e);
            }
            catch (IOException e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    void lockSharedContext() throws IdASException {
        if (this._iLockCount == 0) {
            this._readOnlyContext.lock();
            this._readOnlyContext.syncFile();
        }
        ++this._iLockCount;
    }

    void unlockSharedContext() {
        --this._iLockCount;
        if (this._iLockCount == 0) {
            this._readOnlyContext.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String open(Object identity) throws IdASException {
        if (this._bIsOpen) {
            throw new ContextOpenException("nonsharedContext:open(): Context already open");
        }
        try {
            this.lockSharedContext();
            this._szEntityID = this._readOnlyContext.open(identity);
            this._bIsOpen = true;
            this._identity = identity instanceof AuthNAnonymousMaterials ? "[ANONYMOUS]" : identity;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.unlockSharedContext();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.unlockSharedContext();
            return this._szEntityID;
        }
    }

    protected void finalize() {
        if (this._bIsOpen) {
            try {
                this.close();
            }
            catch (IdASException idASException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonSharedContext:close(): Context not open");
        }
        this._emitXDASRecord(0x1000008, 0, this._identity.toString(), null, null);
        this._log.debug((Object)("Context closed: " + this._szContextURIs + " as: " + this._identity.toString()));
        if (this._readOnlyContext != null) {
            if (this._iLockCount > 0) {
                this._readOnlyContext.unlock();
                this._iLockCount = 0;
            }
            HashMap hashMap = NonsharedContextFactory.SharedContextTable;
            synchronized (hashMap) {
                this._readOnlyContext.decrOpenCount();
                this._readOnlyContext.setLastCloseTime(System.currentTimeMillis());
            }
            this._readOnlyContext = null;
        }
        this._bIsOpen = false;
        this._identity = null;
    }

    public boolean isOpen(Object identity) throws IdASException {
        return this._bIsOpen;
    }

    boolean isOpen() {
        return this._bIsOpen;
    }

    SharedContext getSharedContext() {
        return this._updateContext == null ? this._readOnlyContext : this._updateContext;
    }

    boolean beginTrans() throws IdASException {
        this.lockSharedContext();
        if (this._updateContext == null) {
            this._updateContext = new SharedContext(this._readOnlyContext);
            return true;
        }
        return false;
    }

    public String getSchema() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonSharedContext:getSchema()");
    }

    public IEntity getEntity(String szEntityID) throws IdASException {
        return this.getEntity(szEntityID, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEntity getEntity(String szEntityID, Iterator consumerSelectionList) throws IdASException {
        NonsharedEntity nonsharedEntity;
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:getEntity(entityID,attrList): Context not open");
        }
        try {
            this.lockSharedContext();
            sharedEntity = this.getSharedContext().getEntity(szEntityID);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlockSharedContext();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.unlockSharedContext();
            if (sharedEntity == null) {
                return null;
            }
            nonsharedEntity = new NonsharedEntity(this, sharedEntity);
        }
        return nonsharedEntity;
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        return this.getEntities(filter, null);
    }

    public Iterator getEntities(IFilter filter, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:getEntities(filter,attrlist): Context not open");
        }
        this._emitXDASRecord(0x1000005, 0, this._identity.toString(), filter.toString(), null);
        this._log.debug((Object)("Searching for Entities matching filter: " + filter.toString() + " as: " + this._identity.toString() + " in context: " + this._szContextURIs));
        return new EntityIterator(this, filter);
    }

    /*
     * Exception decompiling
     */
    public void removeEntity(String szEntityID) throws IdASException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 55->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEntity addEntity(URI type, String szEntityID) throws IdASException {
        NonsharedEntity nonsharedEntity;
        boolean bStartedTrans = false;
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:addEntity(type,entityID): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            sharedEntity = this._updateContext.addEntity(type, szEntityID);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bStartedTrans) throw throwable;
            this.unlockSharedContext();
            throw throwable;
        }
        {
            Object var5_7 = null;
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
            if (sharedEntity == null) {
                return null;
            }
            nonsharedEntity = new NonsharedEntity(this, sharedEntity);
        }
        return nonsharedEntity;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
        NonsharedEntity nonsharedEntity;
        boolean bStartedTrans = false;
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:addEntity(copyFrom): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            sharedEntity = this._updateContext.addEntity(copyFrom);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (bStartedTrans) throw throwable;
            this.unlockSharedContext();
            throw throwable;
        }
        {
            Object var4_6 = null;
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
            if (sharedEntity == null) {
                return null;
            }
            nonsharedEntity = new NonsharedEntity(this, sharedEntity);
        }
        return nonsharedEntity;
    }

    public void applyUpdates() throws IdASException {
        if (this._updateContext != null) {
            this._updateContext.applyUpdates();
            this._readOnlyContext.setDataFromContext(this._updateContext);
            this._updateContext = null;
            this.unlockSharedContext();
        }
    }

    public void cancelUpdates() throws IdASException {
        if (this._updateContext != null) {
            this._updateContext = null;
            this.unlockSharedContext();
        }
    }
}

