/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;

/**
 */
public class NonsharedAttributeValueModel implements IAttributeValueModel
{
	private NonsharedAttribute	_nonsharedAttr;
	
	NonsharedAttributeValueModel(
		NonsharedAttribute	nonsharedAttr)
	{
		_nonsharedAttr =  nonsharedAttr;
	}
	
	/**
	 */
	public java.net.URI getType()
	{
		String	szDataType = _nonsharedAttr.getSharedAttribute().getAttrDataType();
		
		if (szDataType == null)
		{
			return( null);
//VISIT: Add this back in if getType starts to throw an exception in new IDAS

//			String	szErrMsg = "No data type defined for attribute '" + _nonsharedAttr.getSharedAttribute().getAttrID() + "'";
//			_log.debug( szErrMsg);
//			throw new IdASException( szErrMsg);
		}
		return( java.net.URI.create( szDataType));
	}

	/**
	 */
	public int getMaxCardinality()
	{
		return( -1);
	}

	/**
	 */
	public int getMinCardinality()
	{
		return( -1);
	}

	/**
	 */
	public boolean isSimple()
	{
		try
		{
			return( _nonsharedAttr.getSharedAttribute().isSimpleDataType());
		}
		catch (IdASException e)
		{
		}
		return( false);
	}
	
	/**
	 */
	public IDisplayData getDisplayData()
	{
		return( null);
	}
}

