/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eclipse.higgins.configuration.api.IConfigurableComponent;

import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.ITypedValue;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;

/**
*
* @author dsanders@novell.com
*
*/

public class NonsharedContextFactory extends BasicAttributeSet implements IContextFactory, IConfigurableComponent
{
	public static final String	XML_FILENAME_SETTING = "XmlFileName";
	
	private Log									_log = LogFactory.getLog( NonsharedContextFactory.class.getName());
	private static java.util.HashMap		_SimpleDataTypes = null;
	
	// Must be visible within the package.
	
	static java.util.HashMap				SharedContextTable = new java.util.HashMap();
	
	/**
	 */
	public NonsharedContextFactory() throws IdASException
	{
		super();
		
		_initSimpleDataTypes();
	}

	public static boolean isSimpleDataType(
		String	szDataType)
	{
		return( _SimpleDataTypes.get( szDataType) != null ? true : false);
	}
			
	/**
	 */
	private static synchronized void _initSimpleDataTypes()
	{
		if (_SimpleDataTypes == null)
		{
			_SimpleDataTypes = new java.util.HashMap();
			for (int iLoop = 0; iLoop < ITypedValue.typeMap.length; iLoop++)
			{
				String []	TypeClass = ITypedValue.typeMap [iLoop];
				
				_SimpleDataTypes.put( TypeClass [0], TypeClass [1]);
			}
		}
	}

	/**
	 */
	public String getName() throws IdASException
	{
		return "Higgins XML File Context Provider";
	}

	/**
	 */
	public java.util.Iterator getContexts(
		String	filter) throws IdASException
	{
		throw new NotImplementedException( "Not Implemented: nonsharedContextFactory:getContexts(filter)" );
	}

	/**
	 */
	public IContext createContext(
		IContextId	contextID) throws IdASException
	{
		java.util.Map		contextSettings = contextID.getConfiguration();
		String				szXmlFileName = (String)contextSettings.get( XML_FILENAME_SETTING);
		SharedContext		sharedCtx;
		int					iLoop;
		java.net.URI []	contextURIs = contextID.getUris();
		String				szContextURIs = "";
		String []			contextTypes = contextID.getTypes();
		String				szContextTypes = "";
		
		for (iLoop = 0; iLoop < contextURIs.length; iLoop++)
		{
			if (iLoop > 0)
			{
				szContextURIs += ", ";
			}
			szContextURIs += contextURIs[iLoop].toString();
		}

		for (iLoop = 0; iLoop < contextTypes.length; iLoop++)
		{
			if (iLoop > 0)
			{
				szContextTypes += ", ";
			}
			szContextTypes += contextTypes[iLoop];
		}
		
		try
		{
			java.io.File	tmpFile = new java.io.File( szXmlFileName);
			
			szXmlFileName = tmpFile.getCanonicalPath();
		}
		catch (Exception e)
		{
			String	szErrMsg = "Error getting canonical path for file name '" + szXmlFileName + "': " + e.getMessage();
			_log.debug( szErrMsg);
			throw new IdASException( szErrMsg); 
		}
		
		// See if we have the file open already.  If so, simply get a reference to it.
		// Lock the file table so that only one thread at a time can do this.
		
		synchronized( SharedContextTable)
		{
			if ((sharedCtx = (SharedContext)SharedContextTable.get( szXmlFileName)) == null)
			{
				sharedCtx = new SharedContext( szXmlFileName);
				sharedCtx.setOpenCount( 1);
				sharedCtx.setLastCloseTime( 0);
				SharedContextTable.put( szXmlFileName, sharedCtx);
			}
			else
			{
				sharedCtx.incrOpenCount();
			}
			
			// Now clean up any files no longer in use.
			
			java.util.Iterator	contextIter = SharedContextTable.keySet().iterator();
			
			while (contextIter.hasNext())
			{
				String			szFileName = (String)contextIter.next();
				SharedContext	tmpSharedCtx = (SharedContext)SharedContextTable.get( szFileName);
				
				// Anything that has been unused for an hour or more should be closed.
				
				if (tmpSharedCtx.getOpenCount() == 0 && tmpSharedCtx.getLastCloseTime() + (long)1000 * (long)3600 < System.currentTimeMillis())
				{
					tmpSharedCtx.close();
					SharedContextTable.remove( szFileName);
				}
			}
		}
		return( new NonsharedContext( sharedCtx, szContextURIs, szContextTypes));
	}

	/**
	 */
	public String getPolicy() throws IdASException
	{
		throw new NotImplementedException( "Not Implemented: nonsharedContextFactory:getPolicy()");
	}

	/**
	 */
	public void setPolicy(
		String arg0) throws IdASException
	{
		throw new NotImplementedException( "Not Implemented: nonsharedContextFactory:setPolicy(arg0)");
	}

	/**
	 */
	public void configure(
		final java.util.Map	mapGlobalSettings,
		final String			szComponentName,
		final java.util.Map	mapComponentSettings) throws Exception
	{
//		_mapGlobalSettings = mapGlobalSettings;
//		_mapComponentSettings = mapComponentSettings;
	}
}

