/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.IAttributeValue;

/**
 */
public class ValueIterator implements java.util.Iterator
{
	private NonsharedAttribute			_nonsharedAttr;
	private SharedAttribute				_sharedAttr;
	private NonsharedAttrContainer	_nonsharedAttrContainer;
	private NonsharedContext			_nonsharedContext;
	private SharedAttributeValue		_currSharedAttrValue;
	private int								_iCurrValueNum;
	
	public ValueIterator(
		NonsharedAttribute	attr)
	{
		_nonsharedAttr = attr;
		_sharedAttr = _nonsharedAttr.getSharedAttribute();
		_nonsharedAttrContainer = _nonsharedAttr.getNonSharedAttrContainer();
		_nonsharedContext = _nonsharedAttrContainer.getNonSharedContext();
		_currSharedAttrValue = null;
		_iCurrValueNum = -1;
	}
	
	private boolean _syncValue(
		boolean	bMustFindExact) throws IdASException
	{
		int	iFoundNum;
		
		// See if we can find the value.
		
		if ((iFoundNum = _sharedAttr.findAttrValue( _currSharedAttrValue)) != -1)
		{
			_currSharedAttrValue = (SharedAttributeValue)_sharedAttr.getValueList().get( iFoundNum);
			_iCurrValueNum = iFoundNum;
		}
		else if (bMustFindExact)
		{
			return( false);
		}
		else
		{
			
			// Could not find the attribute value, assume it has been deleted and sync to the value
			// prior to that one in the list.

			_iCurrValueNum--;
			if (_iCurrValueNum >= 0 && _iCurrValueNum < _sharedAttr.getValueList().size())
			{
				_currSharedAttrValue = (SharedAttributeValue)_sharedAttr.getValueList().get( _iCurrValueNum);
			}
			else
			{
				
				// If we can no longer sync to the value, set _nonsharedAttr to null
				// to disable the iterator.
				
				_nonsharedAttr = null;
				return( false);
			}
		}
		return( true);
	}
	
	private int _getNextValueNum()
	{
		int						iNextValueNum;
		boolean					bSyncedAttr = false;
		
		try
		{
		
			if (_nonsharedAttr != null)
			{
				try
				{
					bSyncedAttr = _nonsharedAttr.sync( false);
				}
				catch (Exception e)
				{
					_nonsharedAttr = null;
				}
			}
			
			// If we no longer have the attribute, there is no next value to get.
			
			if (_nonsharedAttr == null)
			{
				return( -1);
			}
			
			// See if we changed the attribute
			
			if (bSyncedAttr)
			{
				_sharedAttr = _nonsharedAttr.getSharedAttribute();
				if (_currSharedAttrValue != null)
				{
					if (!_syncValue( false))
					{
						return( -1);
					}
				}
			}
			
			// If current attribute is null, it means we have not yet positioned to an attribute
			// for this iterator.
			
			if (_currSharedAttrValue == null)
			{
				iNextValueNum = 0;
			}
			else
			{
				if (_currSharedAttrValue.isDeleted())
				{
					if (!_syncValue( false))
					{
						return( -1);
					}
				}
				iNextValueNum = _iCurrValueNum + 1;
			}
			if (iNextValueNum >= _sharedAttr.getValueList().size())
			{
				return( -1);
			}
			else
			{
				return( iNextValueNum);
			}
		}
		catch (IdASException e)
		{
		}
		return( -1);
	}
	
	public boolean hasNext()
	{
		int	iNextValueNum = -1;
		
		if (!_nonsharedContext.isOpen())
		{
			return( false);
		}
	
		try
		{
			_nonsharedContext.lockSharedContext();
			iNextValueNum = _getNextValueNum();
		}
		catch (IdASException e)
		{
			iNextValueNum = -1;
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		if (iNextValueNum == -1)
		{
			// Set _nonsharedAttr to null to indicate that this iterator can
			// no longer be used to get values.
			_nonsharedAttr = null;
			return( false);
		}
		return( true);
	}
	
	public Object next()
	{
		int						iNextValueNum;
		java.util.ArrayList	valueList;
		IAttributeValue		attrValue = null;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new java.util.NoSuchElementException();
		}
	
		try
		{
			_nonsharedContext.lockSharedContext();
			if ((iNextValueNum = _getNextValueNum()) == -1)
			{
				_nonsharedAttr = null;
				_currSharedAttrValue = null;
				throw new java.util.NoSuchElementException();
			}
			valueList = _sharedAttr.getValueList();
			_currSharedAttrValue = (SharedAttributeValue)valueList.get( iNextValueNum);
			if (_sharedAttr.isSimpleDataType())
			{
				attrValue = new NonsharedSimpleAttrValue( _nonsharedAttr, (SharedSimpleAttrValue)_currSharedAttrValue);
			}
			else
			{
				attrValue = new NonsharedComplexAttrValue( _nonsharedAttr, (SharedComplexAttrValue)_currSharedAttrValue);
			}
			_iCurrValueNum = iNextValueNum;
		}
		catch (IdASException e)
		{
			throw new java.util.NoSuchElementException( "IdAS exception occurred: " + e.getMessage());
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		return( attrValue);
	}
	
	public void remove()
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new java.lang.IllegalStateException( "IdAS context is no longer open");
		}
		else if (_currSharedAttrValue == null || _currSharedAttrValue.isDeleted())
		{
			throw new java.lang.IllegalStateException();
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			if (_nonsharedAttr.sync( bStartedTrans))
			{
				_sharedAttr = _nonsharedAttr.getSharedAttribute();
				if (!_syncValue( true))
				{
					throw new java.util.NoSuchElementException();
				}
			}
			try
			{
				_currSharedAttrValue.remove();
			}
			catch (IdASException e)
			{
				throw new java.util.NoSuchElementException();
			}
		}
		catch (IdASException e)
		{
			throw new java.lang.IllegalStateException( "IdAS exception occured: " + e.getMessage());
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}
}

