/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.audit.api.AuditException;
import org.eclipse.higgins.audit.api.AuditRecord;
import org.eclipse.higgins.configuration.common.ConfigurableComponentFactoryHelper;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.common.AuthNAnonymousMaterials;
import org.eclipse.higgins.idas.cp.xmlfile.EntityIterator;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContextFactory;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedEntity;
import org.eclipse.higgins.idas.cp.xmlfile.SharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedEntity;
import org.eclipse.higgins.idas.spi.BasicContext;

public class NonsharedContext
extends BasicContext {
    private Log _log = LogFactory.getLog((String)(class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContext == null ? (class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContext = NonsharedContext.class$("org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext")) : class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContext).getName());
    private Log _auditLog = LogFactory.getLog((String)"higgins.audit.events");
    private AuditRecord _auditRecord = null;
    private SharedContext _readOnlyContext;
    private SharedContext _updateContext;
    private String _szEntityID;
    private Object _identity = null;
    private int _iLockCount = 0;
    private boolean _bIsOpen = false;
    private long _lLastModifiedTime;
    private long _lSyncCount = 0L;
    private IContextId _contextID;
    private String _contextURIs = "";
    private String _contextTypes = "";
    private Map _contextSettings;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContext;

    public NonsharedContext(SharedContext readOnlyContext, IContextId contextID) throws IdASException {
        int iLoop;
        this._contextID = contextID;
        URI[] contextURIs = this._contextID.getUris();
        for (iLoop = 0; iLoop < contextURIs.length; ++iLoop) {
            this._contextURIs = this._contextURIs + contextURIs[iLoop].toString() + ", ";
        }
        String[] contextTypes = this._contextID.getTypes();
        for (iLoop = 0; iLoop < contextTypes.length; ++iLoop) {
            this._contextTypes = this._contextTypes + contextTypes[iLoop] + ", ";
        }
        this._contextSettings = this._contextID.getConfiguration();
        this._readOnlyContext = readOnlyContext;
        this._lLastModifiedTime = this._readOnlyContext.getLastModifiedTime();
        this._updateContext = null;
        this._bIsOpen = false;
        this._iLockCount = 0;
        this._identity = null;
        this._szEntityID = null;
        String strAuditRecordClass = (String)this._contextSettings.get("AuditRecordClass");
        if (strAuditRecordClass != null) {
            try {
                this._auditRecord = (AuditRecord)ConfigurableComponentFactoryHelper.getInstanceFromClassName((String)strAuditRecordClass);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    long getSyncCount() {
        return this._lSyncCount;
    }

    boolean sync(boolean bForceSync) throws IdASException {
        boolean bSynced = false;
        if (this._updateContext != null) {
            bSynced = bForceSync;
        } else if (bForceSync || this._lLastModifiedTime != this._readOnlyContext.getLastModifiedTime()) {
            this._lLastModifiedTime = this._readOnlyContext.getLastModifiedTime();
            bSynced = true;
        }
        if (bSynced) {
            ++this._lSyncCount;
        }
        return bSynced;
    }

    void lockSharedContext() throws IdASException {
        if (this._iLockCount == 0) {
            this._readOnlyContext.lock();
            this._readOnlyContext.syncFile();
        }
        ++this._iLockCount;
    }

    void unlockSharedContext() {
        --this._iLockCount;
        if (this._iLockCount == 0) {
            this._readOnlyContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String open(Object identity) throws IdASException {
        if (this._bIsOpen) {
            throw new ContextOpenException("nonsharedContext:open(): Context already open");
        }
        try {
            this.lockSharedContext();
            this._szEntityID = this._readOnlyContext.open(identity);
            this._bIsOpen = true;
            this._identity = identity instanceof AuthNAnonymousMaterials ? "[ANONYMOUS]" : identity;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._emitAuditRecord(0x1000007, 0, this._identity.toString(), null, null);
            this.unlockSharedContext();
            throw throwable;
        }
        this._emitAuditRecord(0x1000007, 0, this._identity.toString(), null, null);
        this.unlockSharedContext();
        return this._szEntityID;
    }

    protected void finalize() {
        if (this._bIsOpen) {
            try {
                this.close();
            }
            catch (IdASException idASException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonSharedContext:close(): Context not open");
        }
        this._emitAuditRecord(0x1000008, 0, this._identity.toString(), null, null);
        this._log.debug((Object)("Context closed: " + this._contextURIs + " as: " + this._identity.toString()));
        if (this._readOnlyContext != null) {
            if (this._iLockCount > 0) {
                this._readOnlyContext.unlock();
                this._iLockCount = 0;
            }
            HashMap hashMap = NonsharedContextFactory.SharedContextTable;
            synchronized (hashMap) {
                this._readOnlyContext.decrOpenCount();
                this._readOnlyContext.setLastCloseTime(System.currentTimeMillis());
            }
            this._readOnlyContext = null;
        }
        this._bIsOpen = false;
        this._identity = null;
    }

    public boolean isOpen(Object identity) throws IdASException {
        return this._bIsOpen;
    }

    boolean isOpen() {
        return this._bIsOpen;
    }

    SharedContext getSharedContext() {
        return this._updateContext == null ? this._readOnlyContext : this._updateContext;
    }

    boolean beginTrans() throws IdASException {
        this.lockSharedContext();
        if (this._updateContext == null) {
            this._updateContext = new SharedContext(this._readOnlyContext);
            return true;
        }
        return false;
    }

    public String getSchema() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonSharedContext:getSchema()");
    }

    public IEntity getEntity(String szEntityID) throws IdASException {
        return this.getEntity(szEntityID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntity getEntity(String szEntityID, Iterator consumerSelectionList) throws IdASException {
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:getEntity(entityID,attrList): Context not open");
        }
        try {
            this.lockSharedContext();
            sharedEntity = this.getSharedContext().getEntity(szEntityID);
        }
        finally {
            this.unlockSharedContext();
        }
        return sharedEntity == null ? null : new NonsharedEntity(this, sharedEntity);
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        return this.getEntities(filter, null);
    }

    public Iterator getEntities(IFilter filter, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:getEntities(filter,attrlist): Context not open");
        }
        this._emitAuditRecord(0x1000005, 0, this._identity.toString(), filter.toString(), null);
        this._log.debug((Object)("Searching for Entities matching filter: " + filter.toString() + " as: " + this._identity.toString() + " in context: " + this._contextURIs));
        return new EntityIterator(this, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(String szEntityID) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:removeEntity(entityID): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            this._updateContext.removeEntity(szEntityID);
        }
        finally {
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntity addEntity(URI type, String szEntityID) throws IdASException {
        boolean bStartedTrans = false;
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:addEntity(type,entityID): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            sharedEntity = this._updateContext.addEntity(type, szEntityID);
        }
        finally {
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
        }
        return sharedEntity == null ? null : new NonsharedEntity(this, sharedEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
        boolean bStartedTrans = false;
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:addEntity(copyFrom): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            sharedEntity = this._updateContext.addEntity(copyFrom);
        }
        finally {
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
        }
        return sharedEntity == null ? null : new NonsharedEntity(this, sharedEntity);
    }

    public void applyUpdates() throws IdASException {
        if (this._updateContext != null) {
            this._updateContext.applyUpdates();
            this._readOnlyContext.setDataFromContext(this._updateContext);
            this._updateContext = null;
            this.unlockSharedContext();
        }
    }

    public void cancelUpdates() throws IdASException {
        if (this._updateContext != null) {
            this._updateContext = null;
            this.unlockSharedContext();
        }
    }

    private void _emitAuditRecord(int iEventNumber, int iOutcome, String sInitiatorInfo, String sTargetInfo, String sEventInfo) throws IdASException {
        if (this._auditRecord != null) {
            try {
                this._auditRecord.clearRecord();
                this._auditRecord.setOriginatorInfo("Higgins IdAS JNDI Context Provider", null, null, null, null, null);
                if (sTargetInfo == null) {
                    sTargetInfo = "";
                }
                if (sEventInfo == null) {
                    sEventInfo = "";
                }
                this._auditRecord.setInitiatorInfo(null, null, sInitiatorInfo);
                this._auditRecord.setTargetInfo(null, this._contextURIs, this._contextTypes, null, null, sTargetInfo);
                this._auditLog.info((Object)this._auditRecord);
            }
            catch (AuditException e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

