/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eclipse.higgins.idas.api.IdASException;

import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;

import org.eclipse.higgins.idas.spi.BasicContext;

/**
 */
public class SharedSimpleAttrValue implements SharedAttributeValue
{
	private Log							_log = LogFactory.getLog( SharedSimpleAttrValue.class.getName());
	private SharedAttribute			_sharedAttr;
	private SharedAttrContainer	_sharedAttrContainer;
	private Object						_data;
	private String						_szLexicalData;
	private String						_szCanonicalData;
	private boolean					_bDeleted;

	SharedSimpleAttrValue(
		SharedAttribute	sharedAttr,
		Object				data) throws IdASException
	{
		_bDeleted = false;
		_sharedAttr = sharedAttr;
		_sharedAttrContainer = _sharedAttr.getSharedAttrContainer();
		_setDataFields( data);
	}
	
	private void _setDataFields(
		Object	data) throws IdASException
	{
		ISimpleAttrValue	attrSimpleValue;
		
		if (data == null)
		{
			_data = null;
			_szLexicalData = null;
			_szCanonicalData = null;
		}
		else if (_sharedAttr.getAttrDataType() == null)
		{
			String	szErrMsg = "sharedSimpleAttrValue:_setDataFields(data): Type for value on attribute '" + _sharedAttr.getAttrID() + "' on " +
							_sharedAttrContainer.getContainerType() + " '" + _sharedAttrContainer.getContainerID() + "' not defined";
			_log.debug( szErrMsg);
			throw new IdASException( szErrMsg);
		}
		else
		{
			
			// Create the simple value first.  If it throws an exception, we don't want
			// to alter _data, _szLexicalData, and _szCanonicalData.
			
			attrSimpleValue = BasicContext.createSimpleValue( java.net.URI.create( _sharedAttr.getAttrDataType()), data, null);
			_data = attrSimpleValue.getData();
			_szLexicalData = attrSimpleValue.getLexical();
			_szCanonicalData = attrSimpleValue.getCanonical();
		}
	}
	
	// sharedAttributeValue methods
	
	public void setDeleted()
	{
		_bDeleted = true;
	}
	
	public boolean isDeleted()
	{
		return( _bDeleted);
	}
	
	public boolean isSimple()
	{
		return( true);
	}
	
	public String getDataType()
	{
		return( _sharedAttr.getAttrDataType());
	}

	public void remove() throws IdASException
	{
		java.util.ArrayList	valueList = _sharedAttr.getValueList();
		
		for (int iLoop = 0; iLoop < valueList.size(); iLoop++)
		{
			if (this == (SharedSimpleAttrValue)valueList.get( iLoop))
			{
				valueList.remove( iLoop);
				break;
			}
		}
		_bDeleted = true;
	}
	
	public boolean equals(
		IAttributeValue	simpleValue) throws IdASException
	{
		
		// Make sure the value's type matches the attribute type
	
		if (_sharedAttr.getAttrDataType() == null ||
			 !_sharedAttr.getAttrDataType().equals( ((ISimpleAttrValue)simpleValue).getModel().getType().toString()))
		{
			return( false);
		}
		
		// Must be a simple type
		
		if (!simpleValue.isSimple())
		{
			return( false);
		}
		
		if (_data == null || ((ISimpleAttrValue)simpleValue).getData() == null)
		{
			return( false);
		}
		return( ((ISimpleAttrValue)simpleValue).getCanonical().equals( _szCanonicalData));
	}
	
	// Other methods pertaining to simple values only
	
	public boolean equals(
		SharedAttributeValue	attrValue) throws IdASException
	{
		if (!(attrValue instanceof SharedSimpleAttrValue))
		{
			return( false);
		}
		if (_data == null || ((SharedSimpleAttrValue)attrValue).getData() == null)
		{
			return( false);
		}
		return( ((SharedSimpleAttrValue)attrValue).getCanonical().equals( _szCanonicalData));
	}
	
	/**
	 */
	String getLexical()
	{
		return( _szLexicalData);
	}
	
	String getCanonical()
	{
		return( _szCanonicalData);
	}
	
	/**
	 */
	Object getData()
	{
		return( _data);
	}
	
	/**
	 */
	void setData(
		Object	data) throws IdASException
	{
		String				szErrMsg;
		
		if (_sharedAttr.getAttrDataType() == null)
		{
			szErrMsg = "sharedSimpleAttrValue:setData(data): Type for value on attribute '" + _sharedAttr.getAttrID() + "' on " +
							_sharedAttrContainer.getContainerType() + " '" + _sharedAttrContainer.getContainerID() + "' not defined";
			_log.debug( szErrMsg);
			throw new IdASException( szErrMsg);
		}
		if (data == null)
		{
			szErrMsg = "sharedSimpleAttrvalue:setData(data): Attempt to set a null value for attribute " + _sharedAttr.getAttrID() + " on " +
				_sharedAttrContainer.getContainerType() + " '" + _sharedAttrContainer.getContainerID() + "'";
			_log.debug( szErrMsg);
			throw new IdASException( szErrMsg);
		}
		_setDataFields( data);
	}
}

