/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.eclipse.higgins.idas.api.IdASException;
/**
 * 
 * @author dsanders@novell.com
 * 
 */

public class AttrIterator implements java.util.Iterator
{
	private NonsharedContext			_nonsharedContext;
	private NonsharedAttrContainer	_nonsharedContainer;
	private SharedAttribute				_currAttr;
	private int								_iCurrAttrNum;
	
	public AttrIterator(
		NonsharedAttrContainer	container)
	{
		_nonsharedContainer = container;
		_nonsharedContext = _nonsharedContainer.getNonSharedContext();
		_currAttr = null;
		_iCurrAttrNum = -1;
	}
	
	private boolean _syncAttr(
		boolean	bMustFindExact) throws IdASException
	{
		java.util.ArrayList	attrList = _nonsharedContainer.getAttrList();
		java.util.Map			attrMap = _nonsharedContainer.getAttrMap();
		String					szAttrID = _currAttr.getAttrID();
		SharedAttribute		sharedAttr;
		
		// See if we can find the attr ID.
		
		if ((sharedAttr = (SharedAttribute)attrMap.get( szAttrID)) != null)
		{
			_currAttr = sharedAttr;
			
			// See if it happens to be the same one in the array list.
			
			if (_iCurrAttrNum > attrList.size() ||
				 _currAttr != (SharedAttribute)attrList.get( _iCurrAttrNum))
			{
				
				// Was not in the same place we left it, find it.
				
				for (_iCurrAttrNum = 0; _iCurrAttrNum < attrList.size(); _iCurrAttrNum++)
				{
					if (_currAttr == (SharedAttribute)attrList.get( _iCurrAttrNum))
					{
						break;
					}
				}
			}
		}
		else if (bMustFindExact)
		{
			return( false);
		}
		else
		{
			
			// Could not find the attribute by attr ID, assume it has been deleted and sync to the attribute
			// prior to that one in the list.

			_iCurrAttrNum--;
			if (_iCurrAttrNum >= 0 && _iCurrAttrNum < attrList.size())
			{
				_currAttr = (SharedAttribute)attrList.get( _iCurrAttrNum);
			}
			else
			{
				
				// If we can no longer sync to the attribute, set _nonsharedContainer to null
				// to disable the iterator.
				
				_nonsharedContainer = null;
				return( false);
			}
		}
		return( true);
	}
	
	private int _getNextAttrNum()
	{
		int						iNextAttrNum;
		boolean					bSyncedContainer = false;
		
		try
		{
		
			if (_nonsharedContainer != null)
			{
				try
				{
					bSyncedContainer = _nonsharedContainer.sync( false);
				}
				catch (Exception e)
				{
					_nonsharedContainer = null;
				}
			}
			
			// If we no longer have the container, there is no next attribute to get.
			
			if (_nonsharedContainer == null)
			{
				return( -1);
			}
			
			// See if we updated the attribute container
			
			if (bSyncedContainer)
			{
				if (_currAttr != null)
				{
					if (!_syncAttr( false))
					{
						return( -1);
					}
				}
			}
			
			// If current attribute is null, it means we have not yet positioned to an attribute
			// for this iterator.
			
			if (_currAttr == null)
			{
				iNextAttrNum = 0;
			}
			else
			{
				if (_currAttr.isDeleted())
				{
					if (!_syncAttr( false))
					{
						return( -1);
					}
				}
				iNextAttrNum = _iCurrAttrNum + 1;
			}
			if (iNextAttrNum >= _nonsharedContainer.getAttrList().size())
			{
				return( -1);
			}
			else
			{
				return( iNextAttrNum);
			}
		}
		catch (IdASException e)
		{
		}
		return( -1);
	}
	
	public boolean hasNext()
	{
		int	iNextAttrNum = -1;
		
		if (!_nonsharedContext.isOpen())
		{
			return( false);
		}
	
		try
		{
			_nonsharedContext.lockSharedContext();
			iNextAttrNum = _getNextAttrNum();
		}
		catch (IdASException e)
		{
			iNextAttrNum = -1;
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		if (iNextAttrNum == -1)
		{
			// Set _nonsharedContainer to null to indicate that this iterator can
			// no longer be used to get attributes.
			_nonsharedContainer = null;
			return( false);
		}
		return( true);
	}
	
	public Object next()
	{
		int						iNextAttrNum;
		java.util.ArrayList	attrList;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new java.util.NoSuchElementException();
		}
	
		try
		{
			_nonsharedContext.lockSharedContext();
			if ((iNextAttrNum = _getNextAttrNum()) == -1)
			{
				_nonsharedContainer = null;
				_currAttr = null;
				throw new java.util.NoSuchElementException();
			}
			attrList = _nonsharedContainer.getAttrList();
			_currAttr = (SharedAttribute)attrList.get( iNextAttrNum);
			_iCurrAttrNum = iNextAttrNum;
		}
		catch (IdASException e)
		{
			throw new java.util.NoSuchElementException( "IdAS exception occurred: " + e.getMessage());
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		return( new NonsharedAttribute( _nonsharedContainer, _currAttr));
	}
	
	public void remove()
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new java.lang.IllegalStateException( "IdAS context is no longer open");
		}
		else if (_currAttr == null || _currAttr.isDeleted())
		{
			throw new java.lang.IllegalStateException();
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			if (_nonsharedContainer.sync( bStartedTrans))
			{
				if (!_syncAttr( true))
				{
					throw new java.util.NoSuchElementException();
				}
			}
			_currAttr.remove();
		}
		catch (IdASException e)
		{
			throw new java.lang.IllegalStateException( "IdAS exception occurred: " + e.getMessage());
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}
}

