/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.xmlfile.AttrIterator;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.SharedComplexAttrValue;

public class NonsharedComplexAttrValue
implements IComplexAttrValue,
NonsharedAttrContainer {
    private Log _log = LogFactory.getLog((String)(class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedComplexAttrValue == null ? (class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedComplexAttrValue = NonsharedComplexAttrValue.class$("org.eclipse.higgins.idas.cp.xmlfile.NonsharedComplexAttrValue")) : class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedComplexAttrValue).getName());
    private NonsharedContext _nonsharedContext;
    private NonsharedAttribute _nonsharedAttr;
    private long _lAttrSyncCount;
    private NonsharedAttrContainer _nonsharedAttrContainer;
    private SharedComplexAttrValue _sharedComplexAttrValue;
    private long _lSyncCount = 0L;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedComplexAttrValue;

    NonsharedComplexAttrValue(NonsharedAttribute nonsharedAttr, SharedComplexAttrValue complexValue) {
        this._nonsharedAttr = nonsharedAttr;
        this._lAttrSyncCount = this._nonsharedAttr.getSyncCount();
        this._nonsharedAttrContainer = nonsharedAttr.getNonSharedAttrContainer();
        this._nonsharedContext = this._nonsharedAttrContainer.getNonSharedContext();
        this._sharedComplexAttrValue = complexValue;
    }

    public NonsharedContext getNonSharedContext() {
        return this._nonsharedContext;
    }

    public SharedAttrContainer getSharedContainer() {
        return this._sharedComplexAttrValue;
    }

    public ArrayList getAttrList() {
        return this._sharedComplexAttrValue.getAttrList();
    }

    public Map getAttrMap() {
        return this._sharedComplexAttrValue.getAttrMap();
    }

    public String getContainerType() {
        return "complex attribute";
    }

    public String getContainerID() {
        return this._nonsharedAttr.getSharedAttribute().getAttrID();
    }

    public long getSyncCount() {
        return this._lSyncCount;
    }

    public boolean sync(boolean bForceSync) throws IdASException {
        boolean bSynced = false;
        if (this._nonsharedAttr.sync(bForceSync) || this._lAttrSyncCount != this._nonsharedAttr.getSyncCount()) {
            bForceSync = true;
        }
        if (bForceSync || this._sharedComplexAttrValue == null || this._sharedComplexAttrValue.isDeleted()) {
            int iFoundNum = this._nonsharedAttr.getSharedAttribute().findAttrValue(this._sharedComplexAttrValue);
            this._sharedComplexAttrValue = iFoundNum == -1 ? null : (SharedComplexAttrValue)this._nonsharedAttr.getSharedAttribute().getValueList().get(iFoundNum);
            bSynced = true;
            ++this._lSyncCount;
            this._lAttrSyncCount = this._nonsharedAttr.getSyncCount();
        }
        if (this._sharedComplexAttrValue == null) {
            String szErrMsg = "Value in attribute '" + this._nonsharedAttr.getSharedAttribute().getAttrID() + "' on " + this._nonsharedAttrContainer.getContainerType() + " '" + this._nonsharedAttrContainer.getContainerID() + " no longer exists";
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        return bSynced;
    }

    public boolean isSimple() throws IdASException {
        return false;
    }

    public URI getDataType() throws IdASException {
        return this.getValueType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getValueType() throws IdASException {
        URI dataType = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:getType(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            String szAttrDataType = this._sharedComplexAttrValue.getDataType();
            if (szAttrDataType == null) {
                String szErrMsg = "Data type for value on attribute '" + this._nonsharedAttr.getSharedAttribute().getAttrID() + "' on " + this._nonsharedAttrContainer.getContainerType() + " '" + this._nonsharedAttrContainer.getContainerID() + "' not defined";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            dataType = URI.create(szAttrDataType);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return dataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:remove(): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedComplexAttrValue.remove();
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(IAttributeValue value) throws IdASException {
        boolean bEqual = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:equals(IAttributeValue): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            bEqual = this._sharedComplexAttrValue.equals(value);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return bEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(IHasAttributes attributes) throws IdASException {
        boolean bEqual = true;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:equals(IHasAttributes): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            bEqual = this._sharedComplexAttrValue.equals(attributes);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return bEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAttributes() throws IdASException {
        AttrIterator iter = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:getAttributes(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            iter = new AttrIterator(this);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute getAttribute(URI attrID) throws IdASException {
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:getAttribute(attrID): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            sharedAttr = this._sharedComplexAttrValue.getAttribute(attrID.toString());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:getSingleValuedAttribute(attrID): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            sharedAttr = this._sharedComplexAttrValue.getSingleValuedAttribute(attrID.toString());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        boolean bStartedTrans = false;
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:addAttribute(attrID): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            sharedAttr = this._sharedComplexAttrValue.addAttribute(attrID.toString());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        boolean bStartedTrans = false;
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:addAttribute(copyFrom): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            sharedAttr = this._sharedComplexAttrValue.addAttribute(copyFrom);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(URI attrID) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:removeAttribute(attrID): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedComplexAttrValue.removeAttribute(attrID.toString());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:removeAttributeValue(attrID,value): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedComplexAttrValue.removeAttributeValue(attrID.toString(), value);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeValue(IAttribute attr) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedComplexAttrValue:removeAttributeValue(IAttribute): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedComplexAttrValue.removeAttributeValue(attr);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    public IEntityModel getModel() throws IdASException {
        throw new NotImplementedException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

