/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;

import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;

/**
 */
public class NonsharedSimpleAttrValue implements ISimpleAttrValue
{
	private Log								_log = LogFactory.getLog( NonsharedSimpleAttrValue.class.getName());
	private NonsharedContext			_nonsharedContext;
	private NonsharedAttribute			_nonsharedAttr;
	private long							_lAttrSyncCount;
	private NonsharedAttrContainer	_nonsharedAttrContainer;
	private SharedSimpleAttrValue		_sharedSimpleAttrValue;
	private long							_lSyncCount = 0;

	NonsharedSimpleAttrValue(
		NonsharedAttribute		nonsharedAttr,
		SharedSimpleAttrValue	simpleValue)
	{
		_nonsharedAttr = nonsharedAttr;
		_lAttrSyncCount = _nonsharedAttr.getSyncCount();
		_nonsharedAttrContainer = nonsharedAttr.getNonSharedAttrContainer();
		_nonsharedContext = _nonsharedAttrContainer.getNonSharedContext();
		_sharedSimpleAttrValue = simpleValue;
	}
	
	long getSyncCount()
	{
		return( _lSyncCount);
	}
	
	boolean sync(
		boolean	bForceSync) throws IdASException
	{
		String	szErrMsg;
		boolean	bSynced = false;
		int		iFoundNum;
		
		if (_nonsharedAttr.sync( bForceSync) || _lAttrSyncCount != _nonsharedAttr.getSyncCount())
		{
			bForceSync = true;
		}
		
		// See if we have the value

		if (bForceSync || _sharedSimpleAttrValue == null || _sharedSimpleAttrValue.isDeleted())
		{
			iFoundNum = _nonsharedAttr.getSharedAttribute().findAttrValue( _sharedSimpleAttrValue);
			if (iFoundNum == -1)
			{
				_sharedSimpleAttrValue = null;
			}
			else
			{
				_sharedSimpleAttrValue = (SharedSimpleAttrValue)_nonsharedAttr.getSharedAttribute().getValueList().get( iFoundNum);
			}
			bSynced = true;
			_lSyncCount++;
			_lAttrSyncCount = _nonsharedAttr.getSyncCount();
		}
		if (_sharedSimpleAttrValue == null)
		{
			szErrMsg = "Value in attribute '" + _nonsharedAttr.getSharedAttribute().getAttrID() + "' on " +
				_nonsharedAttrContainer.getContainerType() + " '" + _nonsharedAttrContainer.getContainerID() + " no longer exists";
			
			_log.debug( szErrMsg);
			throw new IdASException( szErrMsg);
		}
		return( bSynced);
	}

	/**
	 */
	public boolean isSimple() throws IdASException
	{
		return( true);
	}

	/**
	 */
	public java.net.URI getDataType() throws IdASException
	{
		return getValueType();
	}

	public URI getValueType() throws IdASException 
	{
		java.net.URI	dataType = null;
		String			szAttrDataType;
		String			szErrMsg;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedSimpleAttrValue:getType(): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			if ((szAttrDataType = _sharedSimpleAttrValue.getDataType()) == null)
			{
				szErrMsg = "Data type for value on attribute '" + _nonsharedAttr.getSharedAttribute().getAttrID() + "' on " +
								_nonsharedAttrContainer.getContainerType() + " '" + _nonsharedAttrContainer.getContainerID() + "' not defined";
				_log.debug( szErrMsg);
				throw new IdASException( szErrMsg);
			}
			dataType = java.net.URI.create( szAttrDataType);
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		
		return( dataType);
	}

	/**
	 */
	public void remove() throws IdASException
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedSimpleAttrValue:remove(): Context not open");
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			sync( bStartedTrans);
			_sharedSimpleAttrValue.remove();
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}
	
	/**
	 */
	public boolean equals(
		IAttributeValue	value) throws IdASException
	{
		boolean	bEqual = true;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedSimpleAttrValue:equals(IAttributeValue): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			bEqual = _sharedSimpleAttrValue.equals( value);
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		
		return( bEqual);
	}
	
	/**
	 */
	public String getLexical() throws IdASException
	{
		String	szValue = null;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedSimpleAttrValue:getLexical(): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			szValue = _sharedSimpleAttrValue.getLexical();
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		return( szValue);
	}
	
	/**
	 */
	public String getCanonical() throws IdASException
	{
		return( getLexical());
	}

	/**
	 */
	public Object getData() throws IdASException
	{
		Object	obj = null;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedSimpleAttrValue:getData(): Context not open");
		}
		
		try
		{
			_nonsharedContext.lockSharedContext();
			sync( false);
			obj = _sharedSimpleAttrValue.getData();
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		return( obj);
	}
	
	/**
	 */
	public void setData(
		Object	data) throws IdASException
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new ContextNotOpenException( "nonsharedSimpleAttrValue:setData(data): Context not open");
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			sync( bStartedTrans);
			_sharedSimpleAttrValue.setData( data);
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}

	public IAttributeSimpleValueModel getModel() throws IdASException {
		throw new NotImplementedException();
	}

	public IAttribute addAttribute(URI attrID) throws IdASException,
			InvalidTypeException {
		throw new NotImplementedException();
	}

	public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
		throw new NotImplementedException();
	}

	public boolean equals(IHasAttributes attributes) throws IdASException {
		throw new NotImplementedException();
	}

	public IAttribute getAttribute(URI attrID) throws IdASException {
		throw new NotImplementedException();
	}

	public Iterator getAttributes() throws IdASException {
		throw new NotImplementedException();
	}

	public ISingleValuedAttribute getSingleValuedAttribute(URI attrID)
			throws IdASException, NotSingleValuedAttributeException {
		throw new NotImplementedException();
	}

	public void removeAttribute(URI attrID) throws IdASException {
		throw new NotImplementedException();
	}

	public void removeAttributeValue(URI attrID, Object value)
			throws IdASException {
		throw new NotImplementedException();
	}

	public void removeAttributeValue(IAttribute attr) throws IdASException {
		throw new NotImplementedException();
	}

}

