/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.xmlfile.AttrIterator;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.SharedEntity;

public class NonsharedEntity
implements IEntity,
NonsharedAttrContainer {
    private Log _log = LogFactory.getLog((String)(class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedEntity == null ? (class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedEntity = NonsharedEntity.class$("org.eclipse.higgins.idas.cp.xmlfile.NonsharedEntity")) : class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedEntity).getName());
    private NonsharedContext _nonsharedContext;
    private long _lContextSyncCount;
    private SharedEntity _sharedEntity;
    private String _szEntityID;
    private long _lSyncCount = 0L;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedEntity;

    NonsharedEntity(NonsharedContext nonsharedCtx, SharedEntity sharedEntity) {
        this._nonsharedContext = nonsharedCtx;
        this._lContextSyncCount = this._nonsharedContext.getSyncCount();
        this._sharedEntity = sharedEntity;
        this._szEntityID = this._sharedEntity.getEntityID();
    }

    public NonsharedContext getNonSharedContext() {
        return this._nonsharedContext;
    }

    public SharedAttrContainer getSharedContainer() {
        return this._sharedEntity;
    }

    public ArrayList getAttrList() {
        return this._sharedEntity.getAttrList();
    }

    public Map getAttrMap() {
        return this._sharedEntity.getAttrMap();
    }

    public String getContainerType() {
        return "Entity";
    }

    public String getContainerID() {
        return this._szEntityID;
    }

    public long getSyncCount() {
        return this._lSyncCount;
    }

    public boolean sync(boolean bForceSync) throws IdASException {
        boolean bSynced = false;
        if (this._nonsharedContext.sync(bForceSync) || this._lContextSyncCount != this._nonsharedContext.getSyncCount()) {
            bForceSync = true;
        }
        if (bForceSync || this._sharedEntity == null || this._sharedEntity.isDeleted()) {
            this._sharedEntity = this._nonsharedContext.getSharedContext().getEntity(this._szEntityID);
            bSynced = true;
            ++this._lSyncCount;
            this._lContextSyncCount = this._nonsharedContext.getSyncCount();
        }
        if (this._sharedEntity == null) {
            String szErrMsg = "Entity '" + this._szEntityID + "' no longer exists";
            this._log.debug((Object)szErrMsg);
            throw new NoSuchEntityException(szErrMsg);
        }
        return bSynced;
    }

    public IContext getContext() throws IdASException {
        return this._nonsharedContext;
    }

    public String getEntityID() throws IdASException {
        return this._szEntityID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getEntityType() throws IdASException {
        URI entityType = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:getEntityType(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            entityType = URI.create(this._sharedEntity.getEntityType());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAttributes() throws IdASException {
        AttrIterator iter = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:getAttributes(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            iter = new AttrIterator(this);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute getAttribute(URI attrID) throws IdASException {
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:getAttribute(attrID): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            sharedAttr = this._sharedEntity.getAttribute(attrID.toString());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    public IEntityModel getModel() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedEntity:getModel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:remove(): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedEntity.remove();
            this._sharedEntity = null;
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:getSingleValuedAttribute(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            sharedAttr = this._sharedEntity.getSingleValuedAttribute(attrID.toString());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        boolean bStartedTrans = false;
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:addAttribute(attrID): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            sharedAttr = this._sharedEntity.addAttribute(attrID.toString());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        boolean bStartedTrans = false;
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:addAttribute(copyFrom): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            sharedAttr = this._sharedEntity.addAttribute(copyFrom);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(URI attrID) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:removeAttribute(attrID): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedEntity.removeAttribute(attrID.toString());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:removeAttributeValue(attrID,value): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedEntity.removeAttributeValue(attrID.toString(), value);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeValue(IAttribute attr) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:removeAttributeValue(IAttribute): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedEntity.removeAttributeValue(attr);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(IHasAttributes attributes) throws IdASException {
        boolean bEqual = true;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedEntity:equals(IHasAttributes): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            bEqual = this._sharedEntity.equals(attributes);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return bEqual;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

