/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.ValueAlreadyExistsException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttributeValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedComplexAttrValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedSimpleAttrValue;

public class SharedAttribute {
    private Log _log;
    private SharedAttrContainer _sharedAttrContainer;
    private String _szAttrID;
    private String _szAttrDataType;
    private boolean _bIsSimpleDataType;
    private boolean _bDeleted;
    private ArrayList _attrValueList;
    static /* synthetic */ Class class$0;

    SharedAttribute(SharedAttrContainer sharedContainer, String szAttrID, String szAttrDataType, boolean bIsSimpleDataType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((String)clazz.getName());
        this._bDeleted = false;
        this._sharedAttrContainer = sharedContainer;
        this._szAttrID = szAttrID;
        this._szAttrDataType = szAttrDataType;
        this._bIsSimpleDataType = bIsSimpleDataType;
        this._attrValueList = new ArrayList();
    }

    void copyValue(SharedAttributeValue copyVal) throws IdASException {
        SharedAttributeValue sharedAttrValue;
        if (copyVal instanceof SharedSimpleAttrValue) {
            sharedAttrValue = new SharedSimpleAttrValue(this, ((SharedSimpleAttrValue)copyVal).getData());
        } else {
            ArrayList copyAttrList = ((SharedComplexAttrValue)copyVal).getAttrList();
            SharedComplexAttrValue complexValue = new SharedComplexAttrValue(this);
            int iLoop = 0;
            while (iLoop < copyAttrList.size()) {
                complexValue.copyAttr((SharedAttribute)copyAttrList.get(iLoop));
                ++iLoop;
            }
            sharedAttrValue = complexValue;
        }
        this._attrValueList.add(sharedAttrValue);
    }

    void addValueToList(SharedAttributeValue attrValue) {
        this._attrValueList.add(attrValue);
    }

    void setDeleted() {
        this._bDeleted = true;
    }

    boolean isDeleted() {
        return this._bDeleted;
    }

    ArrayList getValueList() {
        return this._attrValueList;
    }

    SharedAttrContainer getSharedAttrContainer() {
        return this._sharedAttrContainer;
    }

    String getAttrID() {
        return this._szAttrID;
    }

    String getAttrDataType() {
        return this._szAttrDataType;
    }

    void setAttrDataType(String szAttrDataType, boolean bIsSimpleDataType) {
        this._szAttrDataType = szAttrDataType;
        this._bIsSimpleDataType = bIsSimpleDataType;
    }

    boolean isSimpleDataType() throws IdASException {
        if (this._szAttrDataType == null) {
            String szErrMsg = "Type for value on attribute '" + this._szAttrID + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "' not defined";
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        return this._bIsSimpleDataType;
    }

    SharedSimpleAttrValue addSimpleValue(String szDataType, Object data) throws IdASException, InvalidTypeException {
        SharedSimpleAttrValue simpleValue = null;
        if (!this._szAttrDataType.equals(szDataType)) {
            String szErrMsg = "addSimpleValue(type,data): Invalid value type '" + szDataType + "' specified for attribute '" + this._szAttrID + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "'";
            this._log.debug((Object)szErrMsg);
            throw new InvalidTypeException(szErrMsg);
        }
        simpleValue = new SharedSimpleAttrValue(this, data);
        if (this.findAttrValue(simpleValue) != -1) {
            String szErrMsg = "addSimpleValue(type,data): Attempting to add a duplicate value for attribute '" + this._szAttrID + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "'";
            this._log.debug((Object)szErrMsg);
            throw new ValueAlreadyExistsException(szErrMsg);
        }
        this._attrValueList.add(simpleValue);
        return simpleValue;
    }

    SharedComplexAttrValue addComplexValue(String szDataType) throws IdASException, InvalidTypeException {
        SharedComplexAttrValue complexValue = null;
        if (!this._szAttrDataType.equals(szDataType)) {
            String szErrMsg = "addComplexValue(type): Invalid value type '" + szDataType + "' specified for attribute '" + this._szAttrID + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "'";
            this._log.debug((Object)szErrMsg);
            throw new InvalidTypeException(szErrMsg);
        }
        complexValue = new SharedComplexAttrValue(this);
        this._attrValueList.add(complexValue);
        return complexValue;
    }

    SharedSimpleAttrValue addSimpleValue(IAttributeValue copyFrom) throws IdASException {
        String szDataType = copyFrom.getValueType().toString();
        SharedSimpleAttrValue simpleValue = null;
        if (!this._szAttrDataType.equals(szDataType)) {
            String szErrMsg = "addSimpleValue(copy): Invalid value type '" + szDataType + "' specified for attribute '" + this._szAttrID + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "'";
            this._log.debug((Object)szErrMsg);
            throw new InvalidTypeException(szErrMsg);
        }
        simpleValue = new SharedSimpleAttrValue(this, ((ISimpleAttrValue)copyFrom).getData());
        if (this.findAttrValue(simpleValue) != -1) {
            String szErrMsg = "addSimpleValue(copyFrom): Attempting to add a duplicate value for attribute '" + this._szAttrID + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "'";
            this._log.debug((Object)szErrMsg);
            throw new ValueAlreadyExistsException(szErrMsg);
        }
        this._attrValueList.add(simpleValue);
        return simpleValue;
    }

    SharedComplexAttrValue addComplexValue(IAttributeValue copyFrom) throws IdASException {
        String szDataType = copyFrom.getValueType().toString();
        SharedComplexAttrValue complexValue = null;
        if (!this._szAttrDataType.equals(szDataType)) {
            String szErrMsg = "addSimpleValue(copy): Invalid value type '" + szDataType + "' specified for attribute '" + this._szAttrID + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "'";
            this._log.debug((Object)szErrMsg);
            throw new InvalidTypeException(szErrMsg);
        }
        Iterator attrIter = ((IComplexAttrValue)copyFrom).getAttributes();
        complexValue = new SharedComplexAttrValue(this);
        while (attrIter.hasNext()) {
            complexValue.addAttribute((IAttribute)attrIter.next());
        }
        if (this.findAttrValue(complexValue) != -1) {
            String szErrMsg = "addComplexValue(copyFrom): Attempting to add a duplicate value for attribute '" + this._szAttrID + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "'";
            this._log.debug((Object)szErrMsg);
            throw new ValueAlreadyExistsException(szErrMsg);
        }
        this._attrValueList.add(complexValue);
        return complexValue;
    }

    void remove() throws IdASException {
        this._sharedAttrContainer.removeAttribute(this._szAttrID);
        this._bDeleted = true;
    }

    boolean equals(SharedAttribute testAttr) throws IdASException {
        if (!this._szAttrID.equals(testAttr.getAttrID())) {
            return false;
        }
        String szTestAttrType = testAttr.getAttrDataType();
        if (szTestAttrType != null) {
            if (this._szAttrDataType == null || !this._szAttrDataType.equals(szTestAttrType) || this._bIsSimpleDataType != testAttr.isSimpleDataType()) {
                return false;
            }
        } else {
            return this._szAttrDataType == null;
        }
        ArrayList testValueList = testAttr.getValueList();
        if (testValueList.size() != this._attrValueList.size()) {
            return false;
        }
        HashMap<String, String> matchedValuesMap = new HashMap<String, String>();
        int iLoop = 0;
        while (iLoop < testValueList.size()) {
            int iFoundIndex = this.findAttrValue((SharedAttributeValue)testValueList.get(iLoop));
            if (iFoundIndex == -1) {
                return false;
            }
            if (matchedValuesMap.get("" + iFoundIndex) != null) {
                return false;
            }
            matchedValuesMap.put("" + iFoundIndex, "");
            ++iLoop;
        }
        iLoop = 0;
        while (iLoop < this._attrValueList.size()) {
            if (matchedValuesMap.get("" + iLoop) == null) {
                return false;
            }
            ++iLoop;
        }
        return true;
    }

    boolean equals(IAttribute testAttr) throws IdASException {
        HashMap<String, String> matchedValuesMap;
        int iTestAttrValueCount;
        block16: {
            String szDataType = null;
            boolean bIsSimpleDataType = false;
            if (!this._szAttrID.equals(testAttr.getAttrID().toString())) {
                return false;
            }
            iTestAttrValueCount = 0;
            matchedValuesMap = new HashMap<String, String>();
            Iterator testAttrValueIterator = testAttr.getValues();
            if (testAttrValueIterator != null) {
                while (testAttrValueIterator.hasNext()) {
                    int iFoundIndex;
                    ++iTestAttrValueCount;
                    IAttributeValue testAttrValue = (IAttributeValue)testAttrValueIterator.next();
                    if (szDataType == null) {
                        bIsSimpleDataType = testAttrValue.isSimple();
                        if (bIsSimpleDataType != this._bIsSimpleDataType) {
                            return false;
                        }
                        szDataType = testAttrValue.getValueType().toString();
                        if (this._szAttrDataType == null || !this._szAttrDataType.equals(szDataType)) {
                            return false;
                        }
                    }
                    if ((iFoundIndex = this.findAttrValue(testAttrValue)) == -1) {
                        return false;
                    }
                    if (matchedValuesMap.get("" + iFoundIndex) != null) {
                        return false;
                    }
                    matchedValuesMap.put("" + iFoundIndex, "");
                }
                if (iTestAttrValueCount == 0) {
                    block17: {
                        try {
                            IAttributeValueModel testAttrValueModel;
                            IAttributeModel testAttrModel = testAttr.getModel();
                            if (testAttrModel == null || (testAttrValueModel = testAttrModel.getValueModel()) == null) break block16;
                            szDataType = testAttrValueModel.getType().toString();
                            bIsSimpleDataType = testAttrValueModel.isSimple();
                            if (this._szAttrDataType != null && this._szAttrDataType.equals(szDataType)) break block17;
                            return false;
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    if (bIsSimpleDataType != this._bIsSimpleDataType) {
                        return false;
                    }
                }
            }
        }
        if (iTestAttrValueCount != this._attrValueList.size()) {
            return false;
        }
        int iLoop = 0;
        while (iLoop < this._attrValueList.size()) {
            if (matchedValuesMap.get("" + iLoop) == null) {
                return false;
            }
            ++iLoop;
        }
        return true;
    }

    int findAttrValue(SharedAttributeValue attrValue) throws IdASException {
        int iLoop = 0;
        while (iLoop < this._attrValueList.size()) {
            if (attrValue.equals((SharedAttributeValue)this._attrValueList.get(iLoop))) {
                return iLoop;
            }
            ++iLoop;
        }
        return -1;
    }

    int findAttrValue(IAttributeValue attrValue) throws IdASException {
        int iLoop = 0;
        while (iLoop < this._attrValueList.size()) {
            SharedAttributeValue testValue = (SharedAttributeValue)this._attrValueList.get(iLoop);
            if (testValue.equals(attrValue)) {
                return iLoop;
            }
            ++iLoop;
        }
        return -1;
    }
}

