/**
 * Copyright (c) 2007 Novell, Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 */

/*
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Daniel Sanders
 */

package org.eclipse.higgins.idas.cp.xmlfile;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.IFilter;

/**
 * 
 * @author dsanders@novell.com
 */

public class EntityIterator implements java.util.Iterator
{
	private NonsharedContext		_nonsharedContext;
	private IFilter					_basicFilter;
	private SharedEntity				_currEntity;
	private int					_iCurrEntityNum;
	
	EntityIterator(
		NonsharedContext	context,
		IFilter				basicFilter)
	{
		_nonsharedContext = context;
		_basicFilter = basicFilter;
		_currEntity = null;
		_iCurrEntityNum = -1;
	}
	
	private boolean _syncEntity(
		boolean	bMustFindExact) throws IdASException
	{
		java.util.ArrayList	entityList = _nonsharedContext.getSharedContext().getEntityList();
		java.util.Map			entityMap = _nonsharedContext.getSharedContext().getEntityMap();
		String					szEntityID = _currEntity.getEntityID();
		SharedEntity	sharedEntity;
		
		// See if we can find the entity ID.
		
		if ((sharedEntity = (SharedEntity)entityMap.get( szEntityID)) != null)
		{
			_currEntity = sharedEntity;
			
			// See if it happens to be the same one in the array list.
			
			if (_iCurrEntityNum >= entityList.size() ||
				 _currEntity != (SharedEntity)entityList.get( _iCurrEntityNum))
			{
				
				// Was not in the same place we left it, find it.
				
				for (_iCurrEntityNum = 0; _iCurrEntityNum < entityList.size(); _iCurrEntityNum++)
				{
					if (_currEntity == (SharedEntity)entityList.get( _iCurrEntityNum))
					{
						break;
					}
				}
			}
		}
		else if (bMustFindExact)
		{
			return( false);
		}
		else
		{
			
			// Could not find the Entity by Entity ID, assume it has been deleted and sync to the Entity
			// prior to that one in the list.

			_iCurrEntityNum--;
			if (_iCurrEntityNum >= 0 && _iCurrEntityNum < entityList.size())
			{
				_currEntity = (SharedEntity)entityList.get( _iCurrEntityNum);
			}
			else
			{
				return( false);
			}
		}
		return( true);
	}
	
	private int _getNextEntityNum()
	{
		int						iNextEntityNum;
		java.util.ArrayList	entityList;
		
		try
		{
			
			// See if we switched contexts
			
			if (_nonsharedContext.sync( false))
			{
				if (_currEntity != null)
				{
					if (!_syncEntity( false))
					{
						return( -1);
					}
				}
			}
			
			// If current attribute element is null, it means we have not yet positioned to an element
			// for this iterator.  We will position to the first attribute element under the entity
			// element in that case.
			
			if (_currEntity == null)
			{
				iNextEntityNum = 0;
			}
			else
			{
				if (_currEntity.isDeleted())
				{
					if (!_syncEntity( false))
					{
						return( -1);
					}
				}
				iNextEntityNum = _iCurrEntityNum + 1;
			}
			
			// Need to continue until we find one that matches
			
			entityList = _nonsharedContext.getSharedContext().getEntityList();
			while (iNextEntityNum < entityList.size())
			{
				if (_nonsharedContext.getSharedContext().testEntity( (SharedEntity)entityList.get( iNextEntityNum), _basicFilter))
				{
					return( iNextEntityNum);
				}
				iNextEntityNum++;
			}
		}
		catch (IdASException e)
		{
		}
		return( -1);
	}
	
	public boolean hasNext()
	{
		int	iNextEntityNum = -1;
		
		if (!_nonsharedContext.isOpen())
		{
			return( false);
		}
	
		try
		{
			_nonsharedContext.lockSharedContext();
			iNextEntityNum = _getNextEntityNum();
		}
		catch (IdASException e)
		{
			iNextEntityNum = -1;
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		if (iNextEntityNum == -1)
		{
			return( false);
		}
		return( true);
	}
	
	public Object next()
	{
		int						iNextEntityNum;
		java.util.ArrayList	entityList;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new java.util.NoSuchElementException();
		}
	
		try
		{
			_nonsharedContext.lockSharedContext();
			if ((iNextEntityNum = _getNextEntityNum()) == -1)
			{
				_currEntity = null;
				throw new java.util.NoSuchElementException();
			}
			entityList = _nonsharedContext.getSharedContext().getEntityList();
			_currEntity = (SharedEntity)entityList.get( iNextEntityNum);
			_iCurrEntityNum = iNextEntityNum;
		}
		catch (IdASException e)
		{
			throw new java.util.NoSuchElementException( "IdAS exception occurred: " + e.getMessage());
		}
		finally
		{
			_nonsharedContext.unlockSharedContext();
		}
		return( new NonsharedEntity( _nonsharedContext, _currEntity));
	}
	
	public void remove()
	{
		boolean	bStartedTrans = false;
		
		if (!_nonsharedContext.isOpen())
		{
			throw new java.lang.IllegalStateException( "IdAS context is no longer open");
		}
		else if (_currEntity == null || _currEntity.isDeleted())
		{
			throw new java.lang.IllegalStateException();
		}
		
		try
		{
			bStartedTrans = _nonsharedContext.beginTrans();
			if (_nonsharedContext.sync( bStartedTrans))
			{
				if (!_syncEntity( true))
				{
					throw new java.util.NoSuchElementException();
				}
			}
			_currEntity.remove();
		}
		catch (IdASException e)
		{
			throw new java.lang.IllegalStateException( "IdAS exception occurred: " + e.getMessage());
		}
		finally
		{
			if (!bStartedTrans)
			{
				_nonsharedContext.unlockSharedContext();
			}
		}
	}
}

