/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.registry.contextid;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.higgins.idas.api.IContextId;

public class ConfigurationContextId implements IContextId {

	private String contextId;
	protected String[] types;
	protected URI[] uris;
	protected Map configuration;

	public ConfigurationContextId(Map configuration) {

		List contextIdContextTypeList = (List) configuration.get("ContextTypes");
		List contextIdContextUriList = (List) configuration.get("ContextUris");

		if (contextIdContextTypeList == null) contextIdContextTypeList = new ArrayList();
		if (contextIdContextUriList == null) contextIdContextUriList = new ArrayList();
		
		this.contextId = (String) configuration.get("ContextId");
		this.types = (String[]) contextIdContextTypeList.toArray(new String[contextIdContextTypeList.size()]);
		this.uris = (URI[]) contextIdContextUriList.toArray(new URI[contextIdContextUriList.size()]);
		this.configuration = configuration;
	}

	public String[] getTypes() {

		return(this.types);
	}

	public URI[] getUris() {

		return(this.uris);
	}

	public Map getConfiguration() {

		return(this.configuration);
	}
	
	public String toString() {
		
		return(this.contextId.toString());
	}
	
	public int hashCode() {
		
		return(this.contextId.toString().hashCode());
	}
	
	public boolean equals(Object object) {
		
		if (object == this) return(true);
		if (object == null || ! (object instanceof IContextId)) return(false);
		
		IContextId other = (IContextId) object;
		
		return(this.toString().equals(other.toString()));
	}
}
