/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.registry.contextid;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.contextid.ConfigurationContextId;
import org.eclipse.higgins.idas.registry.contextid.XRDSContextId;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.ResolutionDiscovery;
import org.eclipse.higgins.idas.registry.discovery.StreamDiscovery;
import org.eclipse.higgins.idas.registry.discovery.YadisDiscovery;
import org.openxri.XRI;

public class ContextIdFactory {
    public static IContextId fromString(String string) throws IdASException {
        try {
            return ContextIdFactory.fromConfiguration(string);
        }
        catch (Exception ex) {
            try {
                return ContextIdFactory.fromFile(string);
            }
            catch (Exception ex2) {
                try {
                    return ContextIdFactory.fromXRI(string);
                }
                catch (Exception ex3) {
                    try {
                        return ContextIdFactory.fromUrl(string);
                    }
                    catch (Exception exception) {
                        throw new IdASException("Not a valid context ID: " + string);
                    }
                }
            }
        }
    }

    public static IContextId fromConfiguration(String contextId) throws IdASException {
        IdASRegistry registry = IdASRegistry.getInstance();
        Map contextIdConfiguration = registry.getContextIdConfiguration(contextId);
        return new ConfigurationContextId(contextIdConfiguration);
    }

    public static IContextId fromFile(File file) throws IdASException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.exists()) {
            throw new IdASException("File does not exist.");
        }
        if (!file.isFile()) {
            throw new IdASException("Not a regular file.");
        }
        try {
            return new XRDSContextId(new FileDiscovery(file));
        }
        catch (Exception ex) {
            throw new IdASException("Cannot create context ID from file.");
        }
    }

    public static IContextId fromFile(String string) throws IdASException {
        File file = new File(string);
        return ContextIdFactory.fromFile(file);
    }

    public static IContextId fromXRI(XRI xri) throws IdASException {
        try {
            return new XRDSContextId(new ResolutionDiscovery(xri));
        }
        catch (Exception ex) {
            throw new IdASException("Cannot create context ID from XRI.", (Throwable)ex);
        }
    }

    public static IContextId fromXRI(String string) throws IdASException {
        XRI xri;
        try {
            xri = new XRI(string);
        }
        catch (Exception ex) {
            throw new IdASException("Cannot create XRI from string.", (Throwable)ex);
        }
        return ContextIdFactory.fromXRI(xri);
    }

    public static IContextId fromUrl(URL url) throws IdASException {
        try {
            return new XRDSContextId(new YadisDiscovery(url));
        }
        catch (Exception ex) {
            throw new IdASException("Cannot create context ID from URL.", (Throwable)ex);
        }
    }

    public static IContextId fromUrl(String string) throws IdASException {
        URL url;
        try {
            url = new URL(string);
        }
        catch (Exception ex) {
            throw new IdASException("Cannot create URL from string.", (Throwable)ex);
        }
        return ContextIdFactory.fromUrl(url);
    }

    public static IContextId fromStream(InputStream stream) throws IdASException {
        try {
            return new XRDSContextId(new StreamDiscovery(stream));
        }
        catch (Exception ex) {
            throw new IdASException("Cannot create context ID from stream.", (Throwable)ex);
        }
    }
}

