/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.registry.discovery;

import java.util.ArrayList;
import org.eclipse.higgins.idas.registry.discovery.AbstractDiscovery;
import org.eclipse.higgins.idas.registry.discovery.DiscoveryException;
import org.openxri.XRI;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.TrustType;
import org.openxri.resolve.exception.IllegalTrustTypeException;
import org.openxri.resolve.exception.PartialResolutionException;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class ResolutionDiscovery
extends AbstractDiscovery {
    private static final String DEFAULT_TRUST_TYPE = "none";
    private static final boolean DEFAULT_FOLLOW_REFS = true;
    private XRI xri;
    private String trustType;
    private boolean followRefs;
    private Resolver resolver;

    public ResolutionDiscovery(XRI xri, String trustType, boolean followRefs) {
        this.xri = xri;
        this.trustType = trustType;
        this.followRefs = followRefs;
        this.resolver = this.createResolver();
    }

    public ResolutionDiscovery(XRI xri, String trustType) {
        this(xri, trustType, true);
    }

    public ResolutionDiscovery(XRI xri) {
        this(xri, DEFAULT_TRUST_TYPE, true);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public XRDS discoverXRDS() throws DiscoveryException {
        XRDS xrds;
        try {
            xrds = this.resolver.resolveAuthToXRDS(new XRI(this.xri), new TrustType(this.trustType), this.followRefs);
        }
        catch (PartialResolutionException ex) {
            throw new DiscoveryException("Cannot resolve XRI.", ex);
        }
        catch (IllegalTrustTypeException ex) {
            throw new DiscoveryException("Invalid trust type for XRI resolution.", ex);
        }
        return xrds;
    }

    public Service discoverDefaultService() throws DiscoveryException {
        XRD xrd;
        try {
            xrd = this.resolver.resolveSEPToXRD(new XRI(this.xri), new TrustType(this.trustType), null, null, this.followRefs);
        }
        catch (PartialResolutionException ex) {
            throw new DiscoveryException("Cannot resolve XRI.", ex);
        }
        catch (IllegalTrustTypeException ex) {
            throw new DiscoveryException("Invalid trust type for XRI resolution.", ex);
        }
        ArrayList seps = xrd.getSelectedServices().getList();
        if (seps.size() < 1) {
            return null;
        }
        return (Service)seps.get(0);
    }

    protected Resolver createResolver() {
        Resolver resolver = new Resolver();
        XRD eqRoot = new XRD();
        Service eqAuthService = new Service();
        eqAuthService.addMediaType("application/xrds+xml;trust=none", "content", Boolean.FALSE);
        eqAuthService.addType("xri://$res*auth*($v*2.0)");
        eqAuthService.addURI("http://equal.xri.net");
        eqRoot.addService(eqAuthService);
        XRD atRoot = new XRD();
        Service atAuthService = new Service();
        atAuthService.addMediaType("application/xrds+xml;trust=none", "content", Boolean.FALSE);
        atAuthService.addType("xri://$res*auth*($v*2.0)");
        atAuthService.addURI("http://at.xri.net");
        atRoot.addService(atAuthService);
        XRD bangRoot = new XRD();
        Service bangAuthService = new Service();
        bangAuthService.addMediaType("application/xrds+xml;trust=none", "content", Boolean.FALSE);
        bangAuthService.addType("xri://$res*auth*($v*2.0)");
        bangAuthService.addURI("http://bang.xri.net");
        bangRoot.addService(bangAuthService);
        resolver.setAuthority("=", eqRoot);
        resolver.setAuthority("@", atRoot);
        resolver.setAuthority("!", bangRoot);
        return resolver;
    }

    public boolean isFollowRefs() {
        return this.followRefs;
    }

    public void setFollowRefs(boolean followRefs) {
        this.followRefs = followRefs;
    }

    public String getTrustType() {
        return this.trustType;
    }

    public void setTrustType(String trustType) {
        this.trustType = trustType;
    }

    public XRI getXri() {
        return this.xri;
    }

    public void setXri(XRI xri) {
        this.xri = xri;
    }

    public String toString() {
        return this.xri.toString();
    }
}

