/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;
import org.eclipse.higgins.configuration.xrds.ConfigurationHandler;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.idas.registry.discovery.DiscoveryException;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.eclipse.higgins.util.jscript.JScriptExec;
import org.eclipse.higgins.util.jscript.JScriptExecHelper;
import org.openxri.xml.SEPType;
import org.openxri.xml.Service;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;

public class IdASRegistry
implements IConfigurableComponent,
IConfigurableComponentFactory {
    private static IdASRegistry impl = null;
    public static final String HIGGINS_CONF_NS = "http://higgins.eclipse.org/Configuration";
    private static final String DEFAULT_CONTEXTFACTORIES_XRDS = "contextfactories.xrds";
    protected IDiscovery discovery;
    protected ClassLoader classLoader;
    protected List contextFactoriesList = new ArrayList();
    protected Map contextFactoriesMap = new HashMap();
    protected Map contextIdsMap = new HashMap();
    protected JScriptExec contextIdMapperFunc;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static synchronized IdASRegistry getInstance() {
        if (impl == null) {
            impl = new IdASRegistry();
        }
        return impl;
    }

    public IConfigurableComponent getNewInstance() {
        return new IdASRegistry();
    }

    public IConfigurableComponent getSingletonInstance() {
        return IdASRegistry.getInstance();
    }

    public IdASRegistry() {
        this.discovery = new FileDiscovery(new File(DEFAULT_CONTEXTFACTORIES_XRDS));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.registry.IdASRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classLoader = clazz.getClassLoader();
    }

    public void discover() throws IdASException {
        List seps;
        if (this.discovery == null) {
            throw new NullPointerException();
        }
        this.contextFactoriesList.clear();
        this.contextFactoriesMap.clear();
        try {
            seps = this.discovery.discoverAllServices();
        }
        catch (DiscoveryException ex) {
            throw new IdASException((Throwable)ex);
        }
        Iterator i = seps.iterator();
        while (i.hasNext()) {
            Service sep = (Service)i.next();
            try {
                ArrayList<String> contextFactoryContextTypeList = new ArrayList<String>();
                Iterator ii = sep.getTypes().iterator();
                while (ii.hasNext()) {
                    contextFactoryContextTypeList.add(((SEPType)ii.next()).getType());
                }
                String[] contextFactoryContextTypes = contextFactoryContextTypeList.toArray(new String[contextFactoryContextTypeList.size()]);
                IContextFactory contextFactory = this.instantiateFactory(sep);
                this.registerContextFactory(contextFactoryContextTypes, contextFactory);
            }
            catch (IdASException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IdASException("Cannot instantiate Context Factory.", (Throwable)ex);
            }
        }
    }

    public void discover(String type) throws IdASException {
        List seps;
        if (this.discovery == null) {
            throw new NullPointerException();
        }
        try {
            seps = this.discovery.discoverServices(type, null, null);
        }
        catch (DiscoveryException ex) {
            throw new IdASException((Throwable)ex);
        }
        ArrayList<IContextFactory> typeFactoriesList = new ArrayList<IContextFactory>();
        Iterator i = seps.iterator();
        while (i.hasNext()) {
            Service sep = (Service)i.next();
            try {
                IContextFactory factory = this.instantiateFactory(sep);
                typeFactoriesList.add(factory);
            }
            catch (IdASException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IdASException("Cannot instantiate Context Factory.", (Throwable)ex);
            }
        }
        this.contextFactoriesList.removeAll(typeFactoriesList);
        this.contextFactoriesList.addAll(typeFactoriesList);
        this.contextFactoriesMap.put(type, typeFactoriesList);
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {
        this.contextFactoriesList.clear();
        this.contextFactoriesMap.clear();
        this.contextIdsMap.clear();
        this.contextIdMapperFunc = (JScriptExec)mapComponentSettings.get("JSContextIdMapper");
        List contextFactoryInstances = (List)mapComponentSettings.get("ContextFactoryInstancesList");
        Iterator i = contextFactoryInstances.iterator();
        while (i.hasNext()) {
            Map contextFactoryConfiguration = (Map)i.next();
            String contextFactoryInstanceName = (String)contextFactoryConfiguration.get("Instance");
            List contextFactoryContextTypeList = (List)contextFactoryConfiguration.get("ContextTypes");
            String[] contextFactoryContextTypes = contextFactoryContextTypeList.toArray(new String[contextFactoryContextTypeList.size()]);
            IContextFactory contextFactory = (IContextFactory)mapComponentSettings.get(contextFactoryInstanceName);
            if (contextFactory == null) {
                contextFactory = (IContextFactory)mapGlobalSettings.get(contextFactoryInstanceName);
            }
            this.registerContextFactory(contextFactoryContextTypes, contextFactory);
        }
        List contextIds = (List)mapComponentSettings.get("ContextIdsList");
        Iterator i2 = contextIds.iterator();
        while (i2.hasNext()) {
            Map contextIdConfiguration = (Map)i2.next();
            String contextId = (String)contextIdConfiguration.get("ContextId");
            this.registerContextId(contextId, contextIdConfiguration);
        }
    }

    public Map getContextIdConfiguration(String contextId) {
        String mappedContextId;
        if (this.contextIdMapperFunc == null) {
            mappedContextId = contextId;
        } else {
            try {
                mappedContextId = JScriptExecHelper.transformString((JScriptExec)this.contextIdMapperFunc, (String)"contextId", (String)contextId);
            }
            catch (Exception exception) {
                mappedContextId = contextId;
            }
        }
        return (Map)this.contextIdsMap.get(mappedContextId);
    }

    public List getContextFactories() throws IdASException {
        if (this.contextFactoriesList.isEmpty()) {
            this.discover();
        }
        return this.contextFactoriesList;
    }

    public List getContextFactories(String type) throws IdASException {
        if (!this.contextFactoriesMap.containsKey(type)) {
            this.discover(type);
        }
        if (!this.contextFactoriesMap.containsKey(type)) {
            return new ArrayList();
        }
        return (List)this.contextFactoriesMap.get(type);
    }

    public IContextFactory getContextFactory(String type) throws IdASException {
        List list = this.getContextFactories(type);
        if (list == null || list.size() < 1) {
            return null;
        }
        return (IContextFactory)list.get(0);
    }

    public List getContextFactories(IContextId contextId) throws IdASException {
        ArrayList allFactories = new ArrayList();
        String[] types = contextId.getTypes();
        int i = 0;
        while (i < types.length) {
            List factories = this.getContextFactories(types[i]);
            allFactories.addAll(factories);
            ++i;
        }
        return allFactories;
    }

    public IContextFactory getContextFactory(IContextId contextId) throws IdASException {
        List list = this.getContextFactories(contextId);
        if (list == null || list.size() < 1) {
            return null;
        }
        return (IContextFactory)list.get(0);
    }

    public IContext createContext(IContextId contextId) throws IdASException {
        IContextFactory factory = this.getContextFactory(contextId);
        IContext context = factory.createContext(contextId);
        return context;
    }

    public IContext createContext(String contextIdStr) throws IdASException {
        IContextId contextId = ContextIdFactory.fromString(contextIdStr, this);
        IContextFactory factory = this.getContextFactory(contextId);
        IContext context = factory.createContext(contextId);
        return context;
    }

    public void registerContextFactory(String[] types, IContextFactory factory) {
        if (types == null || factory == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < types.length) {
            ArrayList<IContextFactory> typeFactoriesList = (ArrayList<IContextFactory>)this.contextFactoriesMap.get(types[i]);
            if (typeFactoriesList == null) {
                typeFactoriesList = new ArrayList<IContextFactory>();
            }
            typeFactoriesList.add(factory);
            this.contextFactoriesMap.put(types[i], typeFactoriesList);
            ++i;
        }
        this.contextFactoriesList.add(factory);
    }

    public void registerContextFactory(String type, IContextFactory factory) {
        this.registerContextFactory(new String[]{type}, factory);
    }

    public void registerContextFactory(String[] types, String factoryClassName) throws IdASException {
        IContextFactory factory;
        if (types == null || factoryClassName == null) {
            throw new NullPointerException();
        }
        try {
            factory = this.instantiateFactory(factoryClassName);
        }
        catch (IdASException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IdASException((Throwable)ex);
        }
        this.registerContextFactory(types, factory);
    }

    public void registerContextFactory(String type, String factoryClassName) throws IdASException {
        this.registerContextFactory(new String[]{type}, factoryClassName);
    }

    public void removeContextFactory(IContextFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.contextFactoriesList.remove(factory);
        Iterator i = this.contextFactoriesMap.values().iterator();
        while (i.hasNext()) {
            List typeFactoriesList = (List)i.next();
            typeFactoriesList.remove(factory);
        }
    }

    public void registerContextId(String contextId, Map contextIdConfiguration) throws IdASException {
        this.contextIdsMap.put(contextId, contextIdConfiguration);
    }

    public void removeContextId(String contextId) {
        if (contextId == null) {
            throw new NullPointerException();
        }
        this.contextIdsMap.remove(contextId);
    }

    private IContextFactory instantiateFactory(String factoryClass, Map configuration) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(factoryClass);
        boolean foundInterface = false;
        Class<?> c = clazz;
        while (c != null) {
            Class<?>[] interfaces = c.getInterfaces();
            int j = 0;
            while (j < interfaces.length) {
                Class<?> clazz2 = interfaces[j];
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.higgins.idas.api.IContextFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2 == clazz3) {
                    foundInterface = true;
                    break;
                }
                ++j;
            }
            c = c.getSuperclass();
        }
        if (!foundInterface) {
            return null;
        }
        IContextFactory newFactory = (IContextFactory)clazz.newInstance();
        if (configuration != null) {
            newFactory.configure(null, null, configuration);
        }
        return newFactory;
    }

    private IContextFactory instantiateFactory(String factoryClass) throws Exception {
        return this.instantiateFactory(factoryClass, null);
    }

    private IContextFactory instantiateFactory(Service sep) throws Exception {
        Map configuration;
        Vector values = sep.getOtherTagValues("Class");
        if (values.size() < 1) {
            throw new IdASException("No Context Factory class name found in XRDS service endpoint.");
        }
        String factoryClass = ((CharacterData)((Element)values.get(0)).getFirstChild()).getData();
        ConfigurationHandler handler = new ConfigurationHandler();
        handler.setSEP(sep);
        try {
            handler.configure(null);
            configuration = handler.getSettings();
        }
        catch (Exception ex) {
            throw new IdASException("Cannot read configuration from XRDS service endpoint.", (Throwable)ex);
        }
        return this.instantiateFactory(factoryClass, configuration);
    }

    public void clear() {
        this.contextFactoriesList.clear();
        this.contextFactoriesMap.clear();
        this.contextIdsMap.clear();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public IDiscovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(IDiscovery discovery) {
        this.discovery = discovery;
    }
}

