/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.registry.contextid;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xrds.ConfigurationHandler;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.registry.discovery.DiscoveryException;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;

public class XRDSContextId
implements IContextId {
    private static final Log log;
    protected IDiscovery discovery;
    protected Service sep;
    protected String[] types;
    protected URI[] uris;
    protected Map configuration;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.registry.contextid.XRDSContextId");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public XRDSContextId(IDiscovery discovery) {
        this.discovery = discovery;
        this.sep = null;
        this.types = null;
        this.uris = null;
        this.configuration = null;
    }

    public String[] getTypes() throws IdASException {
        if (this.sep == null) {
            this.resolve();
        }
        return this.types;
    }

    public URI[] getUris() throws IdASException {
        if (this.sep == null) {
            this.resolve();
        }
        return this.uris;
    }

    public Map getConfiguration() throws IdASException {
        if (this.sep == null) {
            this.resolve();
        }
        return this.configuration;
    }

    protected void resolve() throws IdASException {
        try {
            this.sep = this.discovery.discoverDefaultService();
            if (this.sep == null) {
                throw new IdASException("No service endpoint found.");
            }
        }
        catch (DiscoveryException ex) {
            throw new IdASException((Throwable)ex);
        }
        Vector sepTypes = this.sep.getTypes();
        Vector<String> types = new Vector<String>();
        if (sepTypes != null) {
            Iterator i = sepTypes.iterator();
            while (i.hasNext()) {
                SEPType type = (SEPType)i.next();
                if (type.getMatch() != null && !type.getMatch().equals("content")) continue;
                types.add(type.getType());
            }
        }
        this.types = types.toArray(new String[types.size()]);
        Vector sepUris = this.sep.getURIs();
        Vector<URI> uris = new Vector<URI>();
        if (sepUris != null) {
            Iterator i = sepUris.iterator();
            while (i.hasNext()) {
                SEPUri uri = (SEPUri)i.next();
                uris.add(uri.getURI());
            }
        }
        this.uris = uris.toArray(new URI[uris.size()]);
        ConfigurationHandler handler = new ConfigurationHandler();
        handler.setSEP(this.sep);
        try {
            handler.configure(null);
            this.configuration = handler.getSettings();
        }
        catch (Exception ex) {
            log.warn((Object)"Cannot read configuration from XRDS service endpoint.", (Throwable)ex);
            this.configuration = null;
        }
    }

    public String toString() {
        return this.discovery.toString();
    }

    public int hashCode() {
        return this.discovery.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof IContextId)) {
            return false;
        }
        IContextId other = (IContextId)object;
        return this.toString().equals(other.toString());
    }
}

