/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.registry.discovery;

import java.util.List;

import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public interface IDiscovery {

	public XRDS discoverXRDS() throws DiscoveryException;
	public XRD discoverXRD() throws DiscoveryException;
	public List discoverAllServices() throws DiscoveryException;
	public List discoverServices(String type, String mediaType, String path) throws DiscoveryException;
	public Service discoverService(String type, String mediaType, String path) throws DiscoveryException;
	public Service discoverDefaultService() throws DiscoveryException;
}
