/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.registry.discovery;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.higgins.idas.registry.discovery.AbstractDiscovery;
import org.eclipse.higgins.idas.registry.discovery.DiscoveryException;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class StreamDiscovery
extends AbstractDiscovery {
    private InputStream stream;
    private XRDS xrds;

    public StreamDiscovery(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        this.stream = stream;
        this.xrds = null;
    }

    public XRDS discoverXRDS() throws DiscoveryException {
        Document document;
        if (this.xrds != null) {
            return this.xrds;
        }
        try {
            DOMParser domParser = DOMUtils.getDOMParser();
            domParser.parse(new InputSource(this.stream));
            document = domParser.getDocument();
        }
        catch (Exception ex) {
            throw new DiscoveryException("Cannot parse XML.", ex);
        }
        try {
            this.xrds = new XRDS(document.getDocumentElement(), true);
        }
        catch (Exception ex) {
            throw new DiscoveryException("Cannot parse XRDS.", ex);
        }
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            throw new DiscoveryException("Cannot close the file.", ex);
        }
        return this.xrds;
    }

    public String toString() {
        return "stream";
    }
}

