/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;
import org.eclipse.higgins.configuration.xrds.ConfigurationHandler;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.idas.registry.discovery.DiscoveryException;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.eclipse.higgins.util.jscript.JScriptExec;
import org.eclipse.higgins.util.jscript.JScriptExecHelper;
import org.openxri.xml.Service;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;

public class IdASRegistry
implements IConfigurableComponent,
IConfigurableComponentFactory {
    private static IdASRegistry impl = null;
    public static final String HIGGINS_CONF_NS = "http://higgins.eclipse.org/Configuration";
    private static final String DEFAULT_CONTEXTFACTORIES_XRDS = "contextfactories.xrds";
    protected IDiscovery discovery;
    protected ClassLoader classLoader;
    protected List contextFactoriesList = new ArrayList();
    protected Map contextFactoriesMap = new HashMap();
    protected Map contextIdsMap = new HashMap();
    protected JScriptExec contextIdMapperFunc;
    protected List _contextFactoryInstances = null;
    protected List _contextIds = null;
    protected Map _mapGlobalSettings = null;
    protected ISettingDescriptor _globalDescriptor = null;
    protected ISettingDescriptor _componentDescriptor = null;
    protected ISettingDescriptor _idasDescriptor = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$registry$IdASRegistry;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$api$IContextFactory;

    public static synchronized IdASRegistry getInstance() {
        if (impl == null) {
            impl = new IdASRegistry();
        }
        return impl;
    }

    public IConfigurableComponent getNewInstance() {
        return new IdASRegistry();
    }

    public IConfigurableComponent getSingletonInstance() {
        return IdASRegistry.getInstance();
    }

    public IdASRegistry() {
        this.discovery = new FileDiscovery(new File(DEFAULT_CONTEXTFACTORIES_XRDS));
        this.classLoader = (class$org$eclipse$higgins$idas$registry$IdASRegistry == null ? (class$org$eclipse$higgins$idas$registry$IdASRegistry = IdASRegistry.class$("org.eclipse.higgins.idas.registry.IdASRegistry")) : class$org$eclipse$higgins$idas$registry$IdASRegistry).getClassLoader();
    }

    public void discover() throws IdASException {
        List seps;
        if (this.discovery == null) {
            throw new NullPointerException();
        }
        this.contextFactoriesList.clear();
        this.contextFactoriesMap.clear();
        try {
            seps = this.discovery.discoverAllServices();
        }
        catch (DiscoveryException ex) {
            throw new IdASException((Throwable)ex);
        }
        Iterator i = seps.iterator();
        while (i.hasNext()) {
            Service sep = (Service)i.next();
            try {
                IContextFactory contextFactory = this.instantiateFactory(sep);
                this.registerContextFactory(contextFactory, false);
            }
            catch (IdASException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IdASException("Cannot instantiate Context Factory.", (Throwable)ex);
            }
        }
    }

    public void discover(String type) throws IdASException {
        List seps;
        if (this.discovery == null) {
            throw new NullPointerException();
        }
        try {
            seps = this.discovery.discoverServices(type, null, null);
        }
        catch (DiscoveryException ex) {
            throw new IdASException((Throwable)ex);
        }
        ArrayList<IContextFactory> typeFactoriesList = new ArrayList<IContextFactory>();
        Iterator i = seps.iterator();
        while (i.hasNext()) {
            Service sep = (Service)i.next();
            try {
                IContextFactory factory = this.instantiateFactory(sep);
                typeFactoriesList.add(factory);
            }
            catch (IdASException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IdASException("Cannot instantiate Context Factory.", (Throwable)ex);
            }
        }
        this.contextFactoriesList.removeAll(typeFactoriesList);
        this.contextFactoriesList.addAll(typeFactoriesList);
        this.contextFactoriesMap.put(type, typeFactoriesList);
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        this._mapGlobalSettings = mapGlobalSettings;
        this.contextFactoriesList.clear();
        this.contextFactoriesMap.clear();
        this.contextIdsMap.clear();
        this._globalDescriptor = globalDescriptor;
        this._componentDescriptor = componentDescriptor;
        this._idasDescriptor = componentDescriptor.getSubSetting(strComponentName);
        this._contextFactoryInstances = (List)mapComponentSettings.get("ContextFactoryInstancesList");
        this.contextIdMapperFunc = (JScriptExec)mapComponentSettings.get("JSContextIdMapper");
        Iterator i = this._contextFactoryInstances.iterator();
        while (i.hasNext()) {
            Map contextFactoryConfiguration = (Map)i.next();
            String contextFactoryInstanceName = (String)contextFactoryConfiguration.get("Instance");
            IContextFactory contextFactory = (IContextFactory)mapComponentSettings.get(contextFactoryInstanceName);
            if (contextFactory == null) {
                contextFactory = (IContextFactory)mapGlobalSettings.get(contextFactoryInstanceName);
            }
            this.registerContextFactory(contextFactory, false);
        }
        this._contextIds = (List)mapComponentSettings.get("ContextIdsList");
        i = this._contextIds.iterator();
        while (i.hasNext()) {
            Map contextIdConfiguration = (Map)i.next();
            String contextId = (String)contextIdConfiguration.get("ContextId");
            ISettingDescriptor contextDescriptor = this._idasDescriptor.getSubSetting("ContextIdsList").getSubSetting(contextId);
            this.registerContextId(contextId, contextIdConfiguration, contextDescriptor, false);
        }
    }

    public ISettingDescriptor getComponentDescriptor() {
        return this._componentDescriptor;
    }

    public Map getContextIdConfiguration(String contextId) {
        String mappedContextId;
        if (this.contextIdMapperFunc == null) {
            mappedContextId = contextId;
        } else {
            try {
                mappedContextId = JScriptExecHelper.transformString((JScriptExec)this.contextIdMapperFunc, (String)"contextId", (String)contextId);
            }
            catch (Exception e) {
                mappedContextId = contextId;
            }
        }
        return (Map)this.contextIdsMap.get(mappedContextId);
    }

    public List getContextFactories() throws IdASException {
        if (this.contextFactoriesList.isEmpty()) {
            this.discover();
        }
        return this.contextFactoriesList;
    }

    public List getContextFactories(String type) throws IdASException {
        if (!this.contextFactoriesMap.containsKey(type)) {
            this.discover(type);
        }
        if (!this.contextFactoriesMap.containsKey(type)) {
            return new ArrayList();
        }
        return (List)this.contextFactoriesMap.get(type);
    }

    public IContextFactory getContextFactory(String type) throws IdASException {
        List list = this.getContextFactories(type);
        if (list == null || list.size() < 1) {
            return null;
        }
        return (IContextFactory)list.get(0);
    }

    public List getContextFactories(IContextId contextId) throws IdASException {
        ArrayList allFactories = new ArrayList();
        String[] types = contextId.getTypes();
        for (int i = 0; i < types.length; ++i) {
            List factories = this.getContextFactories(types[i]);
            allFactories.addAll(factories);
        }
        return allFactories;
    }

    public IContextFactory getContextFactory(IContextId contextId) throws IdASException {
        List list = this.getContextFactories(contextId);
        if (list == null || list.size() < 1) {
            return null;
        }
        return (IContextFactory)list.get(0);
    }

    public IContext createContext(IContextId contextId) throws IdASException {
        IContextFactory factory = this.getContextFactory(contextId);
        IContext context = factory.createContext(contextId);
        return context;
    }

    public IContext createContext(String contextIdStr) throws IdASException {
        IContextId contextId = ContextIdFactory.fromString(contextIdStr);
        IContextFactory factory = this.getContextFactory(contextId);
        IContext context = factory.createContext(contextId);
        return context;
    }

    public void registerContextFactory(IContextFactory factory, boolean bSave) throws IdASException {
        if (factory == null) {
            throw new NullPointerException();
        }
        List types = factory.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            ArrayList<IContextFactory> typeFactoriesList = (ArrayList<IContextFactory>)this.contextFactoriesMap.get(types.get(i));
            if (typeFactoriesList == null) {
                typeFactoriesList = new ArrayList<IContextFactory>();
            }
            typeFactoriesList.add(factory);
            this.contextFactoriesMap.put(types.get(i), typeFactoriesList);
        }
        this.contextFactoriesList.add(factory);
        if (!bSave) {
            return;
        }
        ISettingDescriptor factoryDescriptor = factory.getComponentDescriptor();
        HashMap<String, Object> contextFactoryMap = new HashMap<String, Object>();
        contextFactoryMap.put("Instance", factoryDescriptor.getName());
        contextFactoryMap.put("ContextTypes", types);
        this._contextFactoryInstances.add(contextFactoryMap);
        this._idasDescriptor.getSubSetting("ContextFactoryInstancesList").addSubSetting(factoryDescriptor);
        this._mapGlobalSettings.put(factoryDescriptor.getName(), factory);
        this._globalDescriptor.addSubSetting(factoryDescriptor.getName(), "htf:classinstance");
    }

    public ISettingDescriptor getContextFactoryDescriptor(String factoryClassName, String[] factoryTypes) {
        if (this.contextFactoriesMap.containsKey(factoryClassName)) {
            return this._idasDescriptor.getSubSetting("ContextFactoryInstancesList").getSubSetting(factoryClassName);
        }
        SettingDescriptor factoryDescriptor = new SettingDescriptor(factoryClassName, "htf:map");
        factoryDescriptor.addSubSetting("Instance", "xsd:string");
        ISettingDescriptor typeDescriptor = factoryDescriptor.addSubSetting("ContextTypes", "htf:list");
        for (int i = 0; i < factoryTypes.length; ++i) {
            typeDescriptor.addSubSetting(factoryTypes[i], "xsd:string");
        }
        return factoryDescriptor;
    }

    public ISettingDescriptor getContextIdDescriptor(String contextIdName, String[] types) throws IdASException {
        if (this.contextIdsMap.containsKey(contextIdName)) {
            return this._idasDescriptor.getSubSetting("ContextIdsList").getSubSetting(contextIdName);
        }
        if (this.contextFactoriesMap.containsKey(types[0])) {
            IContextFactory factory = (IContextFactory)((List)this.contextFactoriesMap.get(types[0])).get(0);
            return factory.getContextDescriptor(contextIdName);
        }
        return null;
    }

    public void registerContextFactory(String[] types, String factoryClassName, ISettingDescriptor factoryDescriptor, boolean bSave) throws IdASException {
        IContextFactory factory;
        if (types == null || factoryClassName == null) {
            throw new NullPointerException();
        }
        HashMap<String, Object> contextFactoryMap = new HashMap<String, Object>();
        contextFactoryMap.put("Instance", factoryDescriptor.getName());
        ArrayList<String> typeList = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            typeList.add(types[i]);
        }
        contextFactoryMap.put("ContextTypes", typeList);
        try {
            factory = this.instantiateFactory(factoryClassName, contextFactoryMap, factoryDescriptor);
        }
        catch (IdASException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IdASException((Throwable)ex);
        }
        this.registerContextFactory(factory, bSave);
    }

    public void registerContextFactory(String type, String factoryClassName, ISettingDescriptor factoryDescriptor, boolean bSave) throws IdASException {
        this.registerContextFactory(new String[]{type}, factoryClassName, factoryDescriptor, bSave);
    }

    public void removeContextFactory(IContextFactory factory) throws IdASException {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.contextFactoriesList.remove(factory);
        Iterator i = this.contextFactoriesMap.values().iterator();
        while (i.hasNext()) {
            List typeFactoriesList = (List)i.next();
            typeFactoriesList.remove(factory);
        }
        for (int j = 0; j < this._contextFactoryInstances.size(); ++j) {
            Map contextFactoryMap = (Map)this._contextFactoryInstances.get(j);
            if (!contextFactoryMap.get("Instance").toString().equals(factory.getName())) continue;
            this._contextFactoryInstances.remove(j);
            this._idasDescriptor.getSubSetting("ContextFactoryInstancesList").removeSubSetting(j);
        }
        this._mapGlobalSettings.remove(factory.getName());
        this._globalDescriptor.removeSubSetting(this._globalDescriptor.getSubSetting(factory.getName()));
    }

    public void registerContextId(String contextId, Map contextIdConfiguration, ISettingDescriptor contextDescriptor, boolean bSave) throws Exception {
        this.contextIdsMap.put(contextId, contextIdConfiguration);
        if (!bSave) {
            return;
        }
        this._contextIds.add(contextIdConfiguration);
        this._idasDescriptor.getSubSetting("ContextIdsList").addSubSetting(contextDescriptor);
    }

    public void removeContextId(String contextId) {
        if (contextId == null) {
            throw new NullPointerException();
        }
        this.contextIdsMap.remove(contextId);
        for (int i = 0; i < this._contextIds.size(); ++i) {
            if (!((Map)this._contextIds.get(i)).get("ContextId").toString().equalsIgnoreCase(contextId)) continue;
            this._contextIds.remove(i);
            this._idasDescriptor.getSubSetting("ContextIdsList").removeSubSetting(i);
            break;
        }
    }

    private IContextFactory instantiateFactory(String factoryClass, Map configuration, ISettingDescriptor factoryDescriptor) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(factoryClass);
        boolean foundInterface = false;
        block0: for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            Class<?>[] interfaces = c.getInterfaces();
            for (int j = 0; j < interfaces.length; ++j) {
                if (interfaces[j] != (class$org$eclipse$higgins$idas$api$IContextFactory == null ? IdASRegistry.class$("org.eclipse.higgins.idas.api.IContextFactory") : class$org$eclipse$higgins$idas$api$IContextFactory)) continue;
                foundInterface = true;
                continue block0;
            }
        }
        if (!foundInterface) {
            return null;
        }
        IContextFactory newFactory = (IContextFactory)clazz.newInstance();
        if (configuration != null) {
            newFactory.configure(null, factoryClass, configuration, factoryDescriptor, this._globalDescriptor);
        }
        return newFactory;
    }

    private IContextFactory instantiateFactory(String factoryClass) throws Exception {
        return this.instantiateFactory(factoryClass, null, null);
    }

    private IContextFactory instantiateFactory(Service sep) throws Exception {
        Map configuration;
        Vector values = sep.getOtherTagValues("Class");
        if (values.size() < 1) {
            throw new IdASException("No Context Factory class name found in XRDS service endpoint.");
        }
        String factoryClass = ((CharacterData)((Element)values.get(0)).getFirstChild()).getData();
        ConfigurationHandler handler = new ConfigurationHandler();
        handler.setSEP(sep);
        try {
            handler.configure(null);
            configuration = handler.getSettings();
        }
        catch (Exception ex) {
            throw new IdASException("Cannot read configuration from XRDS service endpoint.", (Throwable)ex);
        }
        ISettingDescriptor settingDescriptor = handler.getSettingDescriptor();
        return this.instantiateFactory(factoryClass, configuration, settingDescriptor);
    }

    public void clear() {
        this.contextFactoriesList.clear();
        this.contextFactoriesMap.clear();
        this.contextIdsMap.clear();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public IDiscovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(IDiscovery discovery) {
        this.discovery = discovery;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

