/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.registry.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.higgins.idas.registry.discovery.DiscoveryException;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.openxri.resolve.SEPSelector;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public abstract class AbstractDiscovery
implements IDiscovery {
    public abstract XRDS discoverXRDS() throws DiscoveryException;

    public XRD discoverXRD() throws DiscoveryException {
        XRDS xrds = this.discoverXRDS();
        return xrds.getFinalXRD();
    }

    public List discoverAllServices() throws DiscoveryException {
        XRD xrd = this.discoverXRD();
        Vector services = xrd.getServices();
        if (services == null) {
            services = new Vector();
        }
        return services;
    }

    public List discoverServices(String type, String mediaType, String path) throws DiscoveryException {
        SEPSelector selector = new SEPSelector(new ArrayList(this.discoverAllServices()));
        return selector.getSelectedSEPs(type, mediaType, path);
    }

    public Service discoverService(String type, String mediaType, String path) throws DiscoveryException {
        List services = this.discoverServices(type, mediaType, path);
        if (services.size() < 1) {
            return null;
        }
        return (Service)services.get(0);
    }

    public Service discoverDefaultService() throws DiscoveryException {
        return this.discoverService(null, null, null);
    }
}

