/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.registry.discovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.higgins.idas.registry.discovery.AbstractDiscovery;
import org.eclipse.higgins.idas.registry.discovery.DiscoveryException;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class YadisDiscovery
extends AbstractDiscovery {
    private static final String ACCEPT_HEADER = "Accept";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String X_XRDS_LOCATION_HEADER = "X-XRDS-Location";
    private static final String XRDS_MIME_TYPE = "application/xrds+xml";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final int MAX_X_XRDS_LOCATION = 15;
    private static final Pattern HTML_META_REGEX = Pattern.compile(".*?<META\\s+HTTP-EQUIV=\"X-XRDS-Location\"\\s+CONTENT=\"(.+?)\"\\s*>.*|.*?<META\\s+CONTENT=\"(.+?)\"\\s+HTTP-EQUIV=\"X-XRDS-Location\"\\s*>.*", 34);
    private URL url;

    public YadisDiscovery(URL url) {
        this.url = url;
    }

    public XRDS discoverXRDS() throws DiscoveryException {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new NullTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new NullHostnameVerifier());
        }
        catch (Exception exception) {}
        HttpURLConnection.setFollowRedirects(true);
        HttpsURLConnection.setFollowRedirects(true);
        return this.yadisHead(this.url);
    }

    public XRDS yadisHead(URL url) throws DiscoveryException {
        return this.yadisHead(url, true, 1);
    }

    private XRDS yadisHead(URL url, boolean fallbackToGet, int depth) throws DiscoveryException {
        URLConnection connection;
        try {
            connection = url.openConnection();
        }
        catch (IOException ex) {
            throw new DiscoveryException("Cannot open connection to " + url.toString(), ex);
        }
        if (!(connection instanceof HttpURLConnection)) {
            throw new DiscoveryException("Yadis discovery only works with HTTP(S) URLs.");
        }
        try {
            ((HttpURLConnection)connection).setRequestMethod("HEAD");
            ((HttpURLConnection)connection).addRequestProperty(ACCEPT_HEADER, XRDS_MIME_TYPE);
        }
        catch (Exception ex) {
            throw new DiscoveryException("Protocol not supported.", ex);
        }
        if (connection.getHeaderField(X_XRDS_LOCATION_HEADER) != null) {
            URL newUrl;
            try {
                newUrl = new URL(connection.getHeaderField(X_XRDS_LOCATION_HEADER));
            }
            catch (MalformedURLException ex) {
                throw new DiscoveryException("URL found in X-XRDS-Location header is malformed.", ex);
            }
            if (newUrl.equals(url)) {
                throw new DiscoveryException("URL " + url + " points back to itself. Aborting.");
            }
            if (depth > 15) {
                throw new DiscoveryException("Aborting after 15 X-XRDS-Location headers without finding an XRDS document. Aborting.");
            }
            return this.yadisGet(newUrl, depth + 1);
        }
        if (XRDS_MIME_TYPE.equals(connection.getHeaderField(CONTENT_TYPE_HEADER))) {
            return this.yadisGet(url, depth + 1);
        }
        if (fallbackToGet) {
            return this.yadisGet(url, depth + 1);
        }
        throw new DiscoveryException("Failed to discover any XRDS document from URL: " + url.toString());
    }

    public XRDS yadisGet(URL url) throws DiscoveryException {
        return this.yadisGet(url, 1);
    }

    public XRDS yadisGet(URL url, int depth) throws DiscoveryException {
        String document;
        Matcher matcher;
        URL newUrl;
        byte[] body;
        URLConnection connection;
        try {
            connection = url.openConnection();
        }
        catch (IOException ex) {
            throw new DiscoveryException("Cannot open connection to " + url.toString(), ex);
        }
        if (!(connection instanceof HttpURLConnection)) {
            throw new DiscoveryException("Yadis discovery only works with HTTP(S) URLs.");
        }
        try {
            ((HttpURLConnection)connection).setRequestMethod("GET");
            ((HttpURLConnection)connection).addRequestProperty(ACCEPT_HEADER, XRDS_MIME_TYPE);
        }
        catch (Exception ex) {
            throw new DiscoveryException("Protocol not supported.", ex);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int count;
            InputStream stream = connection.getInputStream();
            byte[] b = new byte[8192];
            while ((count = stream.read(b)) > 0) {
                buffer.write(b, 0, count);
            }
            stream.close();
            body = buffer.toByteArray();
        }
        catch (IOException ex) {
            throw new DiscoveryException("Cannot read document", ex);
        }
        String headerField = connection.getHeaderField(CONTENT_TYPE_HEADER);
        if (headerField != null && headerField.toLowerCase().indexOf(XRDS_MIME_TYPE.toLowerCase()) >= 0) {
            XRDS xrds;
            Document document2;
            try {
                DOMParser domParser = DOMUtils.getDOMParser();
                domParser.parse(new InputSource(new ByteArrayInputStream(body)));
                document2 = domParser.getDocument();
            }
            catch (Exception ex) {
                throw new DiscoveryException("Cannot parse XML.", ex);
            }
            try {
                xrds = new XRDS(document2.getDocumentElement(), true);
            }
            catch (Exception ex) {
                throw new DiscoveryException("Cannot parse XRDS.", ex);
            }
            return xrds;
        }
        if (connection.getHeaderField(X_XRDS_LOCATION_HEADER) != null) {
            try {
                newUrl = new URL(connection.getHeaderField(X_XRDS_LOCATION_HEADER));
            }
            catch (MalformedURLException ex) {
                throw new DiscoveryException("URL found in X-XRDS-Location header is malformed.", ex);
            }
            if (newUrl.equals(url)) {
                throw new DiscoveryException("URL " + url + " points back to itself. Aborting.");
            }
            if (depth > 15) {
                throw new DiscoveryException("Aborting after 15 X-XRDS-Location headers without finding an XRDS document. Aborting.");
            }
            return this.yadisGet(newUrl, depth + 1);
        }
        headerField = connection.getHeaderField(CONTENT_TYPE_HEADER);
        if (headerField != null && headerField.toLowerCase().indexOf(HTML_MIME_TYPE.toLowerCase()) >= 0 && (matcher = HTML_META_REGEX.matcher(document = new String(body))).matches() && matcher.groupCount() > 0) {
            try {
                newUrl = new URL(matcher.group(1));
            }
            catch (MalformedURLException ex) {
                throw new DiscoveryException("URL found in X-XRDS-Location header is malformed.", ex);
            }
            if (newUrl.equals(url)) {
                throw new DiscoveryException("URL " + url + " points back to itself. Aborting.");
            }
            if (depth > 15) {
                throw new DiscoveryException("Aborting after 15 X-XRDS-Location headers without finding an XRDS document. Aborting.");
            }
            return this.yadisGet(newUrl, depth + 1);
        }
        throw new DiscoveryException("Failed to discover any XRDS document from URL: " + url.toString());
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String toString() {
        return this.url.toString();
    }

    private static class NullHostnameVerifier
    implements HostnameVerifier {
        private NullHostnameVerifier() {
        }

        public boolean verify(String rserver, SSLSession sses) {
            return true;
        }
    }

    private static class NullTrustManager
    implements X509TrustManager {
        private NullTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

