/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.registry.discovery;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.xerces.parsers.DOMParser;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/**
 * A Discovery implementation that reads an XRDS document from a file.
 * @author msabadello at parityinc dot net
 */
public class FileDiscovery extends AbstractDiscovery {

	private File file;

	public FileDiscovery(File file) {

		this.file = file;
	}

	public XRDS discoverXRDS() throws DiscoveryException {

		// open the file

		InputStream stream;
		
		try {

			stream = new FileInputStream(this.file);
		} catch (IOException ex) {

			throw new DiscoveryException("Cannot open the file.", ex);
		}

		// parse XML document from input stream

		Document document; 

		try {

			DOMParser domParser = DOMUtils.getDOMParser();

			domParser.parse(new InputSource(new FileInputStream(this.file)));
			document = domParser.getDocument();
		} catch (Exception ex) {

			throw new DiscoveryException("Cannot parse XML.", ex);
		}

		// build XRDS object from XML document

		XRDS xrds;

		try {

			xrds = new XRDS(document.getDocumentElement(), true);
		} catch (Exception ex) {

			throw new DiscoveryException("Cannot parse XRDS.", ex);
		}

		// close the file
		
		try {
		
			stream.close();
		} catch (IOException ex) {
			
			throw new DiscoveryException("Cannot close the file.", ex);
		}
		
		// done

		return(xrds);
	}
	
	public String toString() {
		
		return(this.file.getPath());
	}
}
