/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.spi.AttributeValueNotification;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicMetadataSet;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;

public abstract class AbstractComplexValue
extends BasicAttributeSet
implements IComplexAttrValue {
    private IAttributeValueContainer _container = null;
    private BasicMetadataSet _metaSet = null;

    public AbstractComplexValue() throws IdASException {
        this._metaSet = new BasicMetadataSet();
    }

    public AbstractComplexValue(IAttributeValueContainer container) throws IdASException {
        this._container = container;
        this._metaSet = new BasicMetadataSet();
    }

    public AbstractComplexValue(Iterator attrs, IAttributeValueContainer container) throws IdASException {
        super(attrs, null, null);
        this._container = container;
        this._metaSet = new BasicMetadataSet();
    }

    public boolean isSimple() throws IdASException {
        return false;
    }

    public void remove() throws IdASException {
        if (this._container != null) {
            AttributeValueNotification attrValueNotif = new AttributeValueNotification((IAttributeValue)this, "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE", null);
            this._container.updateNotification(attrValueNotif);
        }
    }

    public boolean equals(IAttributeValue value) throws IdASException {
        if (value.isSimple()) {
            return false;
        }
        if (value.getType() != this.getType()) {
            return false;
        }
        if (!this.equals((IHasMetadata)value)) {
            return false;
        }
        IComplexAttrValue val = (IComplexAttrValue)value;
        return this.equals((IHasAttributes)val);
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        return this._metaSet.equals(metadataSet);
    }

    public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
        return this._metaSet.addMetadata(metadataID);
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        return this._metaSet.addMetadata(copyFrom);
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        return this._metaSet.getMetadata(metadataID);
    }

    public Iterator getMetadataSet() throws IdASException {
        return this._metaSet.getMetadataSet();
    }
}

