/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.AttributeValueNotification;
import org.eclipse.higgins.idas.spi.BasicComplexValue;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicMetadataSet;
import org.eclipse.higgins.idas.spi.BasicSimpleValue;
import org.eclipse.higgins.idas.spi.IAttributeContainer;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;
import org.eclipse.higgins.idas.spi.IMetadataContainer;
import org.eclipse.higgins.idas.spi.MetadataNotification;

public class BasicAttribute
implements IAttribute,
IAttributeValueContainer,
IMetadataContainer {
    private Logger _log = Logger.getLogger((String)(class$org$eclipse$higgins$idas$spi$BasicAttribute == null ? (class$org$eclipse$higgins$idas$spi$BasicAttribute = BasicAttribute.class$("org.eclipse.higgins.idas.spi.BasicAttribute")) : class$org$eclipse$higgins$idas$spi$BasicAttribute).getName());
    private URI _attrID;
    private Vector _values;
    private IAttributeContainer _container;
    private IContext _context;
    private BasicMetadataSet _metaSetImpl;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$spi$BasicAttribute;

    public BasicAttribute(IAttribute copyFrom, IAttributeContainer container, IContext context) throws IdASException {
        this._context = context;
        this._init(copyFrom.getAttrID(), copyFrom.getValues(), copyFrom.getMetadataSet(), container);
    }

    public BasicAttribute(URI attrID, IAttributeValue value, IAttributeContainer container, IContext context) throws IdASException {
        this._context = context;
        if (value != null) {
            Vector<IAttributeValue> v = new Vector<IAttributeValue>(1);
            v.add(value);
            this._init(attrID, v.iterator(), null, container);
        } else {
            this._init(attrID, null, null, container);
        }
    }

    public BasicAttribute(URI attrID, Object data, IAttributeContainer container, IContext context) throws IdASException {
        this._context = context;
        IAttributeValueModel valueModel = this.getModel().getValueModel();
        URI valueType = valueModel.getType();
        ISimpleAttrValue value = BasicContext.createSimpleValue(valueType, data, this);
        if (value != null) {
            Vector<ISimpleAttrValue> v = new Vector<ISimpleAttrValue>(1);
            v.add(value);
            this._init(attrID, v.iterator(), null, container);
        } else {
            this._init(attrID, null, null, container);
        }
    }

    public BasicAttribute(URI attrID, Iterator values, IAttributeContainer container, IContext context) throws IdASException {
        this._context = context;
        this._init(attrID, values, null, container);
    }

    private void _init(URI attrID, Iterator values, Iterator metaSet, IAttributeContainer container) throws IdASException {
        this._attrID = attrID;
        this._container = container;
        this._values = new Vector();
        if (values != null) {
            while (values.hasNext()) {
                this._addValue((IAttributeValue)values.next());
            }
        }
        this._metaSetImpl = new BasicMetadataSet(metaSet, this);
    }

    private void _addValue(IAttributeValue val) throws IdASException {
        this._values.add(val);
        this._log.debug((Object)("Sending value add notification - " + val.getType().toString()));
        AttributeValueNotification valueNotif = new AttributeValueNotification(val, "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ADD", null);
        this.updateNotification(valueNotif);
    }

    private boolean _containsValue(IAttributeValue value) throws IdASException {
        Iterator iter = this.getValues();
        boolean bRet = false;
        while (iter.hasNext()) {
            IAttributeValue localVal = (IAttributeValue)iter.next();
            if (!localVal.equals(value)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public URI getAttrID() throws IdASException {
        return this._attrID;
    }

    public Iterator getValues() throws IdASException {
        return ((Vector)this._values.clone()).iterator();
    }

    public IAttributeModel getModel() throws IdASException {
        if (this._context != null) {
            return (IAttributeModel)this._context.getModel(this.getAttrID());
        }
        throw new NotImplementedException("No associated context to obtain model");
    }

    public IComplexAttrValue addComplexValue(URI type) throws IdASException, InvalidTypeException {
        BasicComplexValue val = new BasicComplexValue(type, null, this);
        this._addValue((IAttributeValue)val);
        return val;
    }

    public ISimpleAttrValue addSimpleValue(URI type, Object data) throws IdASException, InvalidTypeException {
        ISimpleAttrValue val = BasicContext.createSimpleValue(type, data, this);
        this._addValue((IAttributeValue)val);
        return val;
    }

    public IAttributeValue addValue(URI type) throws IdASException, InvalidTypeException {
        IAttributeValueModel valueModel = this.getModel().getValueModel();
        Object val = valueModel.isSimple() ? new BasicSimpleValue(type, null, this) : new BasicComplexValue(type, null, this);
        this._addValue((IAttributeValue)val);
        return val;
    }

    public IAttributeValue addValue(IAttributeValue copyFrom) throws IdASException {
        Object val;
        if (copyFrom.isSimple()) {
            ISimpleAttrValue simpleCopyFrom = (ISimpleAttrValue)copyFrom;
            val = new BasicSimpleValue(simpleCopyFrom.getType(), simpleCopyFrom.getData(), this);
        } else {
            IComplexAttrValue complexCopyFrom = (IComplexAttrValue)copyFrom;
            val = new BasicComplexValue(copyFrom.getType(), complexCopyFrom.getAttributes(), this);
        }
        this._addValue((IAttributeValue)val);
        return val;
    }

    public void remove() throws IdASException {
        if (this._container != null) {
            AttributeNotification attrNotif = new AttributeNotification(this, "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_REMOVE", null, null);
            this._log.debug((Object)("Sending attribute remove notification - " + attrNotif.getAction() + ", " + attrNotif.getAttr().getAttrID().toString()));
            this._container.updateNotification(attrNotif);
        }
    }

    public boolean isSingleValued() {
        return false;
    }

    public Iterator getMetadataSet() throws IdASException {
        return this._metaSetImpl.getMetadataSet();
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        return this._metaSetImpl.getMetadata(metadataID);
    }

    public IMetadata addMetadata(URI type) throws IdASException, InvalidTypeException {
        return this._metaSetImpl.addMetadata(type);
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        return this._metaSetImpl.addMetadata(copyFrom);
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        return this._metaSetImpl.equals(metadataSet);
    }

    public void updateNotification(AttributeValueNotification attrValueNotif) throws IdASException {
        this._log.debug((Object)("Received attribute value notification - " + attrValueNotif.getAction() + ", " + attrValueNotif.getAttributeValue().toString()));
        this._log.debug((Object)("_containter " + (this._container != null ? this._container.toString() : "null")));
        if (this._container != null) {
            AttributeNotification attrNotif = new AttributeNotification(this, "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY", attrValueNotif, null);
            this._container.updateNotification(attrNotif);
        }
        if (attrValueNotif.getAction() == "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE") {
            this._values.remove(attrValueNotif.getAttributeValue());
        }
    }

    public void updateNotification(MetadataNotification metaNotif) throws IdASException {
        if (this._container != null) {
            AttributeNotification attrNotif = new AttributeNotification(this, "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_METADATA_NOTIFY", null, metaNotif);
            this._container.updateNotification(attrNotif);
        }
    }

    public void setContainer(IAttributeContainer container) {
        this._container = container;
    }

    public IAttributeContainer getContainer() {
        return this._container;
    }

    public boolean equals(IAttribute attr) throws IdASException {
        boolean bRet;
        if (attr.getAttrID() != this.getAttrID()) {
            bRet = false;
        } else {
            bRet = this.equals((IHasMetadata)attr);
            if (bRet) {
                Iterator iter = attr.getValues();
                while (iter.hasNext()) {
                    if (this._containsValue((IAttributeValue)iter.next())) continue;
                    bRet = false;
                    break;
                }
            }
        }
        return bRet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

