/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.spi.BasicMetadata;
import org.eclipse.higgins.idas.spi.IMetadataContainer;
import org.eclipse.higgins.idas.spi.MetadataNotification;

public class BasicMetadataSet
implements IHasMetadata,
IMetadataContainer {
    private Hashtable _metas;
    private IMetadataContainer _metaContainer = this;

    public BasicMetadataSet() {
        this._metas = new Hashtable();
    }

    public BasicMetadataSet(Iterator metaSet, IMetadataContainer container) throws IdASException {
        this();
        if (container != null) {
            this._metaContainer = container;
        }
        if (metaSet != null) {
            while (metaSet.hasNext()) {
                this.addMetadata((IMetadata)metaSet.next());
            }
        }
    }

    public Iterator getMetadataSet() throws IdASException {
        return this._metas.values().iterator();
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        return (IMetadata)this._metas.get(metadataID);
    }

    public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
        BasicMetadata meta = new BasicMetadata(metadataID, this._metaContainer);
        this.insertMetadata(meta);
        return meta;
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        BasicMetadata meta = new BasicMetadata(copyFrom, this._metaContainer);
        this.insertMetadata(meta);
        return meta;
    }

    protected void insertMetadata(IMetadata meta) throws IdASException {
        this._metas.put(meta.getID(), meta);
    }

    protected void removeMetadata(IMetadata meta) throws IdASException {
        this._metas.remove(meta.getID());
    }

    public void updateNotification(MetadataNotification metaNotif) throws IdASException {
        if (this._metaContainer != this) {
            this._metaContainer.updateNotification(metaNotif);
        }
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        int localCount = 0;
        int metadataCount = 0;
        Iterator iter = metadataSet.getMetadataSet();
        while (iter.hasNext()) {
            IMetadata meta = (IMetadata)iter.next();
            if (!this._contains(meta)) {
                return false;
            }
            ++metadataCount;
        }
        iter = this.getMetadataSet();
        while (iter.hasNext()) {
            iter.next();
            ++localCount;
        }
        return localCount == metadataCount;
    }

    private boolean _contains(IMetadata meta) throws IdASException {
        Iterator iter = this.getMetadataSet();
        while (iter.hasNext()) {
            if (!((IMetadata)iter.next()).equals(meta)) continue;
            return true;
        }
        return false;
    }
}

