/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.nio.ByteBuffer;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.spi.AbstractSimpleValue;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;

public class BasicValueHexBinary
extends AbstractSimpleValue
implements ISimpleAttrValue {
    public BasicValueHexBinary(ByteBuffer data, IAttributeValueContainer container) throws IdASException {
        super.init(ITypedValue.HEXBINARY_TYPE_URI, data, container);
    }

    public BasicValueHexBinary(String data, IAttributeValueContainer container) throws IdASException {
        super.init(ITypedValue.HEXBINARY_TYPE_URI, this._fromHexString(data), container);
    }

    public BasicValueHexBinary(byte[] bytes, IAttributeValueContainer container) throws IdASException {
        super.init(ITypedValue.HEXBINARY_TYPE_URI, ByteBuffer.wrap(bytes), container);
    }

    public String getLexical() throws IdASException {
        return this._toHexString();
    }

    public String getCanonical() throws IdASException {
        return this._toHexString().toUpperCase();
    }

    private String _toHexString() throws IdASException {
        byte[] array = ((ByteBuffer)this.getData()).array();
        StringBuffer sb = new StringBuffer(array.length * 2);
        for (int iLoop = 0; iLoop < array.length; ++iLoop) {
            sb.append(Integer.toHexString(array[iLoop]));
        }
        return sb.toString();
    }

    private ByteBuffer _fromHexString(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int idx = 0; idx < bytes.length; ++idx) {
            bytes[idx] = (byte)Integer.parseInt(hexString.substring(idx * 2, idx * 2 + 2), 16);
        }
        return ByteBuffer.wrap(bytes);
    }
}

