/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;

/**
 * Basic implementation of {@link IComplexAttrValue}. Uses {@link IAttributeValueContainer}. 
 *
 */
public abstract class AbstractComplexValue extends BasicAttributeSet implements IComplexAttrValue {
	private IAttributeValueContainer _container = null;
	private BasicMetadataSet _metaSet = null; 

	public AbstractComplexValue() throws IdASException {
		super();
		_metaSet = new BasicMetadataSet();
	}

	public AbstractComplexValue(IAttributeValueContainer container) throws IdASException {
		super();
		_container = container;
		_metaSet = new BasicMetadataSet();
	}

	/**
	 * Note that the container's updateNotification is not called while 
	 * the attributes in attrs are being added.
	 * @param attrs Contains {@link IAttribute}s.
	 */
	public AbstractComplexValue(Iterator attrs, IAttributeValueContainer container) throws IdASException {
		super(attrs, null, null);
		_container = container;
		_metaSet = new BasicMetadataSet();
	}

	public boolean isSimple() throws IdASException {
		return false;
	}

	public void remove() throws IdASException {
		if (_container != null) {
			AttributeValueNotification attrValueNotif = new AttributeValueNotification(this, AttributeValueNotification.UPDATE_REMOVE, null);
			_container.updateNotification(attrValueNotif);
		}
	}

	public boolean equals(IAttributeValue value) throws IdASException {
		if (value.isSimple())
			return false;
		if (value.getType() != this.getType())
			return false;
		if (this.equals((IHasMetadata)value) == false)
			return false;

		IComplexAttrValue val = (IComplexAttrValue)value;
		return ((BasicAttributeSet)this).equals((IHasAttributes)val);
	}

	public boolean equals(IHasMetadata metadataSet) throws IdASException {
		return _metaSet.equals(metadataSet);
	}

	public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
		return _metaSet.addMetadata(metadataID);
	}

	public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
		return _metaSet.addMetadata(copyFrom);
	}

	public IMetadata getMetadata(URI metadataID) throws IdASException {
		return _metaSet.getMetadata(metadataID);
	}

	public Iterator getMetadataSet() throws IdASException {
		return _metaSet.getMetadataSet();
	}
}
