/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicFilterAssertion implements IFilterAssertion {

	private URI _id;
	private boolean _bIncludeSubtypes = false;
	private String _comparator;
	
	public BasicFilterAssertion() {
	}

	public BasicFilterAssertion(URI id, String comparator) throws IdASException {
		this(id, false, comparator);
	}

	public BasicFilterAssertion(URI id, boolean bIncludeSubtypes, String comparator) throws IdASException {
		setID(id, bIncludeSubtypes);
		setComparator(comparator);
	}

	public void setComparator(String comparator) throws IdASException {
		_comparator = comparator;
	}

	public void setID(URI id, boolean bIncludeSubtypes) throws IdASException {
		includeSubtypes(bIncludeSubtypes);
		setID(id);
	}

	public void setID(URI id) throws IdASException {
		_id = id;
	}

	public void includeSubtypes(boolean bIncludeSubtypes) throws IdASException {
		_bIncludeSubtypes = true;
	}
	
	public String getComparator() throws IdASException {
		return _comparator;
	}
	
	public URI getID() throws IdASException {
		return _id;
	}
	
	public boolean getIncludeSubtypes() throws IdASException {
		return _bIncludeSubtypes;
	}


}
